// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include "TrackDialog.h"
#include "CDTrack.h"
#include "TOCReader.h"

#include <kapp.h>
#include <klocale.h>
#include <kconfig.h>



#include <qwindowdefs.h>
#include <qlistview.h>
#include <qlayout.h>
#include <qpushbutton.h>



#include <strings.h>
#include <stdio.h>
#include <stdlib.h>


extern KLocale *locale;

TrackDialog::TrackDialog( QWidget *parent, const char *name,TOCReader *toc):QDialog(parent,name,TRUE)
 {
  int i;

  qvlayout=new QVBoxLayout(this);
  
  this->setCaption(locale->translate("Select track:"));

  tracklist=new QListView(this,"track dialog listview");
  tracklist->addColumn(locale->translate("Track"),-1);
  tracklist->addColumn(locale->translate("Duration"),-1);
  tracklist->addColumn(locale->translate("Mode"),-1);
  tracklist->setMinimumSize(tracklist->sizeHint());


  for (i=1;i<99;++i)
   {
    long duration;
    char tempstring[80];
    QListViewItem *lvi;
    enum CDTrack::TrackType ttype;

    duration=toc->getTOCDuration(i);
    if (duration==-1) break;
    lvi=new QListViewItem(tracklist); 
    sprintf(tempstring,"%4d",i);
    lvi->setText(0,tempstring);
    CDTrack::getDurationHMSB(tempstring,duration);
    lvi->setText(1,tempstring);
    ttype=toc->getTOCType(i);
    CDTrack::getTypeString(ttype,tempstring);
    lvi->setText(2,tempstring);
   }
  
  tracklist->resize(tracklist->sizeHint());
  qcancel=new QPushButton(locale->translate("Abort"),this,"trackdialog abort");
  qcancel->setFixedSize(qcancel->sizeHint());
  

  qvlayout->addWidget(tracklist,8);
  qvlayout->addStretch(1);
  qvlayout->addWidget(qcancel);
  qvlayout->activate();


  connect(tracklist,SIGNAL(selectionChanged(QListViewItem *)),this,SLOT(changeCurrent(QListViewItem *)));
  connect(qcancel,SIGNAL(clicked()),this,SLOT(cancelPressed()));

 }

void TrackDialog::changeCurrent(QListViewItem *change)
 {
  long int track;
  track=strtol(change->text(0),0,10);
  if ( (track<1) || (track>99) ) return;
  done(track);
 }

void TrackDialog::cancelPressed(void)
 {
  done(0);
 }
