// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "TOCCdda2wav.h"
#include "pathconfig.h"
#include "uidcontrol.h"

#include <kapp.h>
#include <kconfig.h>
#include <klocale.h>

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

extern KLocale *locale;

int TOCCdda2wav::invokeTOCReader(void)
 {
  int i;
  KConfig *config;
  char devline[32];
  int host,unit;

  prepareProcess(ProgressDialog::Progress_None);
#if QT_VERSION >=200
  config=kapp->config();
#else
  config=kapp->getConfig();
#endif
  config->setGroup("SCSI");
  host=config->readNumEntry("SCSICdromHost",0);
  unit=config->readNumEntry("SCSICdromUnit",-1);
  if (unit==-1) return(0);
  sprintf(devline,"-D %d,%d,0",host,unit);

  config->setGroup("Path");
  if ROOT_CALLED
   {
    *this<<config->readEntry("PathCdda2wav",PATH_CDDA2WAV)<<"-g"<<"-J"<<"-t"<<"100"<<devline;
   }
   else
   {
    *this<<PATH_CDDA2WAV<<"-g"<<"-J"<<"-t"<<"100"<<devline;
   }

  for (i=0;i<128;++i)
   {
    toc_lba[i]=-1;
   }


  setWorkText(locale->translate("Scanning TOC..."));
  startProcess();
  closeProcess();
  closeTOC();
  if (toctracks==0) return(0);
  return(1);
 }

bool TOCCdda2wav::processStderrLine(char *linebuffer)
 {
   char *cptr=0,*duraptr=0,*tokptr=0,*trashptr=0,*lbaptr=0,*token=0;
   int freetoc=0;
   if (strncmp("scanning for ISRC",linebuffer,17)==0)
     {
      return (false);
     }
    if (strncmp("load cdrom please",linebuffer,17)==0)
     {
      return(false);
     }

  if ( (linebuffer[0]=='T') && (linebuffer[3]==':') &&
       (linebuffer[1]>='0') && (linebuffer[2]>='0') &&
       (linebuffer[1]<='9') && (linebuffer[2]<='9') )
   {
    long int ints[8];
    cptr=linebuffer+4;
    while (toc_lba[freetoc]!=-1) freetoc++;
    toc_ttype[freetoc]=CDTrack::Track_Audio;
    lbaptr=cptr;
    while (*lbaptr==' ') lbaptr++;
    if (*lbaptr==0) return(true);
    duraptr=lbaptr;
    while ( (*duraptr!=' ') && (*duraptr!=0)) duraptr++;
    if (*duraptr==0) return(true);
    while (*duraptr==' ') duraptr++;
    if (*duraptr==0) return(true);
    tokptr=duraptr;
    while ( (*tokptr!=' ') && (*tokptr!=0)) tokptr++;
    if (*tokptr==0) return(true);
   ints[0]=strtol(lbaptr,&trashptr,10);
   sscanf(duraptr,"%ld:%ld.%ld",&ints[1],&ints[2],&ints[3]);
   while (*tokptr!=0)
     {
      token=tokptr;
      while ( (*tokptr!=' ') && (*tokptr!=0) ) ++tokptr;
      trashptr=tokptr;
      while ( *tokptr==' ') ++tokptr;
      *trashptr=0;
      if (strcmp(token,"audio")==0) toc_ttype[freetoc]=CDTrack::Track_Audio;
      if (strcmp(token,"data")==0) toc_ttype[freetoc]=CDTrack::Track_DataMode1;
       // tokens "linear" , "copydenied" , "stero" , "title" , "from" , "uninterrupted" known but not handled
     }
    toc_lba[freetoc]=ints[0];
    toc_durat[freetoc]=ints[1]*75*60+ints[2]*75+ints[3];
   }
  return(true);
 }
