// KreateCD - CD recording seoftware for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifndef PROCESSINTERFACE_INCLUDED
#define PROCESSINTERFACE_INCLUDED

#include <qobject.h>


/**
    @short ProcessInterface - base class for helper application interaction
    @author Alexander Feigl <Alexander.Feigl@gmx.de>

*/

#include "ProgressDialog.h"

class KProcess;
class AudioFileOp;
class QTimer;

class ProcessInterface : public QObject
 {
  Q_OBJECT

  typedef ProgressDialog::ProgressType ProgressType;


  protected:
    ProcessInterface(void);
    ProcessInterface(int (*fx)(int argc,char **argv));
    ProcessInterface(int (*fx)(AudioFileOp *afi,const char *fn),AudioFileOp *afil,const char *fnx);
    ~ProcessInterface(void);

    void writeStdin(char *buffer,int len);

  public:
    ProcessInterface& operator<<(const char *arg);

  protected slots:
    void        processStdout(KProcess *proc,char *buffer,int bufflen);
    void        processStderr(KProcess *proc,char *buffer,int bufflen);
    void        processLeave (KProcess *proc);
    void        cancelPressed(void);
    void        triggerTimer(void);

  protected:

    void         prepareProcess(ProgressType ptype=ProgressDialog::Progress_Single);
    int          startProcess(bool rootrights=true,bool progressdialog=true);
    void         closeProcess(void);
    void         setProgress(long int val,long int max,bool protect=false);
    void         setWorkText(const char *worktext);
    void         sendSignal(int signal);
    void         printStatusLine(QString line);
    void         addStatusView(void);
    void         showDialog(void);
    void         hideDialog(void);
    void         setForkArgument(const char *arg);
    void         setLineTimeout(int timeout);

    virtual bool processStdoutLine(char *linebuffer);
    virtual bool processStderrLine(char *linebuffer);
    virtual int  processExited(void);
    virtual void processCancel(void);

  private:

    char stdOutBuffer[512];
    char stdErrBuffer[512];
    ProgressDialog *progressDialog;
    KProcess *process;

    bool      forkProcess;
    bool      forkAudio;
    bool      showProgress;
    int (*forkFunc)(int argc,char **argv);
    int (*forkFuncAudio)(AudioFileOp *afi,const char *fn);
    AudioFileOp *audioFileOp;
    const char *audioForkArg;

    QTimer *outputTimer;
    bool outPending;
    bool errPending;
    bool blockTimer;
    int outTimed;
    int errTimed;

    int lineTimeout;
 };

#endif
