// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifndef DEVICERIPPER_INCLUDED
#define DEVICERIPPER_INCLUDED


#include "DataRipper.h"

/**
    @short DeviceRipper - class for ripping data with /dev/
    @author Alexander Feigl <Alexander.Feigl@gmx.de>
    @version $id$

*/

class DeviceRipper : public DataRipper
 {
  Q_OBJECT

  public:
    DeviceRipper(void);

  protected:
    virtual bool processStderrLine(char *linebuffer);
    virtual bool ripDataTrack(char *filename,long int lba_start,long int size_hint);

  private:
    static int readiso(int argc,char **argv);
    static int read_cdrom(int file,char *buffer,long int size,long int lba);
    static long int getISOBlocks(int cdrom,long int iso_root);
    static int readCDROM(int cdrom,long int start_block,long int iso_size,char *outfile,int isomode);

    bool ignoreAll;
 };


#endif
