// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include "ConfPath.h"

#include <qstring.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlineedit.h>

#include <kapp.h>
#include <klocale.h>
#include <kconfig.h>
#include <kfiledialog.h>
#include <kurl.h>

#include <strings.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>

#include "pathconfig.h"
#include "uidcontrol.h"

extern KLocale *locale;

ConfPath::ConfPath( QWidget *parent, const char *name):QWidget(parent,name)
 {
  KConfig *config;
  QVBoxLayout *qwinlay;
  QHBoxLayout *buttonlayout;
  QGridLayout *qgrid;
  QPushButton *parabut,*cdrbut,*mkisobut,*cddabut,*tmpbut;

  QRect DefaultRect(100,50,500,300);
#if QT_VERSION >= 200
  config=kapp->config();
#else
  config=kapp->getConfig();
#endif

  qwinlay=new QVBoxLayout(this);
  qgrid=new QGridLayout(11,6);
  qwinlay->addStretch(1);
  qwinlay->addLayout(qgrid,10);
  qwinlay->addStretch(1);

  setCaption(locale->translate("KreateCD - path configuration"));

  qgrid->setColStretch(0,3);
  qgrid->setColStretch(3,3);
  qgrid->setColStretch(5,3);
  qgrid->setColStretch(1,10);
  qgrid->setColStretch(2,20);
  qgrid->setColStretch(4,0);
  qgrid->setRowStretch(0,1);
  qgrid->setRowStretch(2,1);
  qgrid->setRowStretch(4,1);
  qgrid->setRowStretch(6,1);
  qgrid->setRowStretch(8,1);
  qgrid->setRowStretch(10,1);


  ParanoiaLabel=new QLabel(locale->translate("Path: cdparanoia"),this);
  ParanoiaLabel->setMinimumSize(ParanoiaLabel->sizeHint());
  ParanoiaPath=new QLineEdit(this,"paranoia path");
  ParanoiaPath->setMaxLength(39);
  ParanoiaPath->setMinimumSize(ParanoiaPath->sizeHint());
  qgrid->addWidget(ParanoiaLabel,1,1,AlignCenter);
  qgrid->addWidget(ParanoiaPath,1,2);

  CdrecordLabel=new QLabel(locale->translate("Path: cdrecord"),this);
  CdrecordLabel->setMinimumSize(CdrecordLabel->sizeHint());
  CdrecordPath=new QLineEdit(this,"cdrecord path");
  CdrecordPath->setMaxLength(39);
  CdrecordPath->setMinimumSize(CdrecordPath->sizeHint());
  qgrid->addWidget(CdrecordLabel,3,1,AlignCenter);
  qgrid->addWidget(CdrecordPath,3,2);

  IsofsLabel=new QLabel(locale->translate("Path: mkisofs"),this);
  IsofsLabel->setMinimumSize(IsofsLabel->sizeHint());
  IsofsPath=new QLineEdit(this,"mkisofs path");
  IsofsPath->setMaxLength(39);
  IsofsPath->setMinimumSize(IsofsPath->sizeHint());
  qgrid->addWidget(IsofsLabel,5,1,AlignCenter);
  qgrid->addWidget(IsofsPath,5,2);

  CddawavLabel=new QLabel(locale->translate("Path: cdda2wav"),this);
  CddawavLabel->setMinimumSize(CddawavLabel->sizeHint());
  CddawavPath=new QLineEdit(this,"cdda2wav path");
  CddawavPath->setMaxLength(39);
  CddawavPath->setMinimumSize(CddawavPath->sizeHint());
  qgrid->addWidget(CddawavLabel,7,1,AlignCenter);
  qgrid->addWidget(CddawavPath,7,2);

  TemporaryLabel=new QLabel(locale->translate("Temporary directory"),this);
  TemporaryLabel->setMinimumSize(TemporaryLabel->sizeHint());
  TemporaryPath=new QLineEdit(this,"temporary path");
  TemporaryPath->setMaxLength(39);
  TemporaryPath->setMinimumSize(TemporaryPath->sizeHint());
  qgrid->addWidget(TemporaryLabel,9,1,AlignCenter);
  qgrid->addWidget(TemporaryPath,9,2);

  parabut=new QPushButton("...",this);
  parabut->setFixedSize(parabut->sizeHint());
  qgrid->addWidget(parabut,1,4,AlignCenter);
  cdrbut=new QPushButton("...",this);
  cdrbut->setFixedSize(parabut->sizeHint());
  qgrid->addWidget(cdrbut,3,4,AlignCenter);
  mkisobut=new QPushButton("...",this);
  mkisobut->setFixedSize(parabut->sizeHint());
  qgrid->addWidget(mkisobut,5,4,AlignCenter);
  cddabut=new QPushButton("...",this);
  cddabut->setFixedSize(parabut->sizeHint());
  qgrid->addWidget(cddabut,7,4,AlignCenter);
  tmpbut=new QPushButton("...",this);
  tmpbut->setFixedSize(parabut->sizeHint());
  qgrid->addWidget(tmpbut,9,4,AlignCenter);


  buttonlayout=new QHBoxLayout();
  qwinlay->addLayout(buttonlayout,1);

  okbutton=new QPushButton(locale->translate("OK"),this);
  okbutton->setFixedSize(okbutton->sizeHint());
  buttonlayout->addStretch();
  buttonlayout->addWidget(okbutton,1,AlignCenter);
  buttonlayout->addStretch();
  applybutton=new QPushButton(locale->translate("Apply"),this);
  applybutton->setFixedSize(applybutton->sizeHint());
  buttonlayout->addWidget(applybutton,1,AlignCenter);
  buttonlayout->addStretch();
  cancelbutton=new QPushButton(locale->translate("Cancel"),this);
  cancelbutton->setFixedSize(cancelbutton->sizeHint());
  buttonlayout->addWidget(cancelbutton,1,AlignCenter);
  buttonlayout->addStretch();

  connect(okbutton,SIGNAL(clicked()),this,SLOT(okButton()));
  connect(applybutton,SIGNAL(clicked()),this,SLOT(applySettings()));
  connect(cancelbutton,SIGNAL(clicked()),this,SLOT(cancelButton()));
  connect(parabut,SIGNAL(clicked()),this,SLOT(changeParanoia()));
  connect(cdrbut,SIGNAL(clicked()),this,SLOT(changeCdrecord()));
  connect(mkisobut,SIGNAL(clicked()),this,SLOT(changeMkisofs()));
  connect(cddabut,SIGNAL(clicked()),this,SLOT(changeCddawav()));
  connect(tmpbut,SIGNAL(clicked()),this,SLOT(changeTemp()));

   {
    QString tstring;
    config->setGroup("Path");
    if ROOT_CALLED
     {
      tstring=config->readEntry("PathCdparanoia",PATH_CDPARANOIA);
      ParanoiaPath->setText(tstring.data());
      ParanoiaPath->setEnabled(FALSE);
     }
     else
     {
      ParanoiaPath->setText(PATH_CDPARANOIA);
     }
    if ROOT_CALLED
     {
      tstring=config->readEntry("PathCdrecord",PATH_CDRECORD);
      CdrecordPath->setText(tstring.data());
      CdrecordPath->setEnabled(FALSE);    
     }
     else
     {
      CdrecordPath->setText(PATH_CDRECORD);
     }   
    if ROOT_CALLED
     {
      tstring=config->readEntry("PathMkisofs",PATH_MKISOFS);
      IsofsPath->setText(tstring.data());
      IsofsPath->setEnabled(FALSE);
     }
     else
     {
      IsofsPath->setText(PATH_MKISOFS);
     }
    if ROOT_CALLED
     {
      tstring=config->readEntry("PathCdda2wav",PATH_CDDA2WAV);
      CddawavPath->setText(tstring.data());
      CddawavPath->setEnabled(FALSE);
     }
     else
     {
      CddawavPath->setText(PATH_CDDA2WAV);
     }
    tstring=config->readEntry("PathTemporary","/tmp/");
    TemporaryPath->setText(tstring.data());
   }
  

  config->setGroup("Geometry");
  this->setGeometry(config->readRectEntry("PathWindowGeo",&DefaultRect));
  qwinlay->activate();
 }


ConfPath::~ConfPath(void)
 {
  KConfig *config;
  QRect SaveRect(this->pos(),this->size());
#if QT_VERSION >= 200
  config=kapp->config();
#else
  config=kapp->getConfig();
#endif
  config->setGroup("Geometry");
  config->writeEntry("PathWindowGeo",SaveRect);
 }

void ConfPath::applySettings(void)
 {
  KConfig *config;
#if QT_VERSION >= 200
  config=kapp->config();
#else
  config=kapp->getConfig();
#endif
  config->setGroup("Path");
  config->writeEntry("PathCdparanoia",ParanoiaPath->text());
  config->writeEntry("PathCdrecord",CdrecordPath->text());
  config->writeEntry("PathMkisofs",IsofsPath->text());
  config->writeEntry("PathCdda2wav",CddawavPath->text());
  config->writeEntry("PathTemporary",TemporaryPath->text());

 }

void ConfPath::hide()
 {
  QWidget::hide();
  emit closed();

 }

void ConfPath::okButton(void)
 {
  applySettings();
  hide();
 }

void ConfPath::cancelButton(void)
 {
  hide();
 }


int ConfPath::verifyPrograms(void)
 {
  int retv=1;
  const char *prog;
  QString progqs;
  KConfig *config;
  struct stat statbuf;

#if QT_VERSION >= 200
  config=kapp->config();
#else
  config=kapp->getConfig();
#endif
  config->setGroup("Path");
  progqs=config->readEntry("PathCdrecord",PATH_CDRECORD);
  prog=progqs.data();
  if ( (prog[0]==0) || (stat(prog,&statbuf)!=0) )
   {
    retv=0;
   }

  progqs=config->readEntry("PathCdparanoia",PATH_CDPARANOIA);
  prog=progqs.data();
  if ( (prog[0]==0) || (stat(prog,&statbuf)!=0) )
   {
    retv=0;
   }

  progqs=config->readEntry("PathMkisofs",PATH_MKISOFS);
  prog=progqs.data();
  if ( (prog[0]==0) || (stat(prog,&statbuf)!=0) )
   {
    retv=0;
   }

  progqs=config->readEntry("PathCdda2wav",PATH_CDDA2WAV);
  prog=progqs.data();
  if ( (prog[0]==0) || (stat(prog,&statbuf)!=0) )
   {
    retv=0;
   }

  progqs=config->readEntry("PathTemporary","");
  prog=progqs.data();
  if ( (prog[0]==0))
   {
    config->writeEntry("PathTemporary","/tmp");
   }

  return(retv);
 }


void ConfPath::changeParanoia(void)
 {
  QString openname;
#if QT_VERSION >= 200
  openname=KFileDialog::getOpenURL(ParanoiaPath->text(),"*",this,locale->translate("Select location of cdparanoia")).path();
  KURL::decode(openname);
#else
  openname=KFileDialog::getOpenFileName(ParanoiaPath->text(),"*",this,locale->translate("Select location of cdparanoia"));
  KURL::decodeURL(openname);
#endif
  if (openname.isEmpty()) return;
  ParanoiaPath->setText(openname);
 }

void ConfPath::changeCdrecord(void)
 {
  QString openname;
#if QT_VERSION >= 200
  openname=KFileDialog::getOpenURL(CdrecordPath->text(),"*",this,locale->translate("Select location of cdrecord")).path();
  KURL::decode(openname);
#else
  openname=KFileDialog::getOpenFileName(CdrecordPath->text(),"*",this,locale->translate("Select location of cdrecord"));
  KURL::decodeURL(openname);
#endif
  if (openname.isEmpty()) return;
  CdrecordPath->setText(openname);
 }

void ConfPath::changeMkisofs(void)
 {
  QString openname;
#if QT_VERSION >= 200
  openname=KFileDialog::getOpenURL(IsofsPath->text(),"*",this,locale->translate("Select location of mkisofs")).path();
  KURL::decode(openname);
#else
  openname=KFileDialog::getOpenFileName(IsofsPath->text(),"*",this,locale->translate("Select location of mkisofs"));
  KURL::decodeURL(openname);
#endif
  if (openname.isEmpty()) return;
  IsofsPath->setText(openname);
 }

void ConfPath::changeCddawav(void)
 {
  QString openname;
#if QT_VERSION >= 200
  openname=KFileDialog::getOpenURL(CddawavPath->text(),"*",this,locale->translate("Select location of cdda2wav")).path();
  KURL::decode(openname);
#else
  openname=KFileDialog::getOpenFileName(CddawavPath->text(),"*",this,locale->translate("Select location of cdda2wav"));
  KURL::decodeURL(openname);
#endif
  if (openname.isEmpty()) return;
  CddawavPath->setText(openname);
 }

void ConfPath::changeTemp(void)
 {
  QString openname;
#if QT_VERSION >= 200
  openname=KFileDialog::getOpenURL(TemporaryPath->text(),"*",this,locale->translate("Select temporary directory")).path();
  KURL::decode(openname);
#else
  openname=KFileDialog::getOpenFileName(TemporaryPath->text(),"*",this,locale->translate("Select temporary directory"));
  KURL::decodeURL(openname);
#endif
  if (openname.isEmpty()) return;
  TemporaryPath->setText(openname);
 }
