// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifndef AUDIOBUILDIMAGE_INCLUDED
#define AUDIOBUILDIMAGE_INCLUDED

#include "AudioFileConvert.h"
#include "AudioFile.h"
#include <qobject.h>

class AudioBuildImage : public AudioFileConvert
 {
   Q_OBJECT

   public:
    AudioBuildImage(AudioFile *afil);
    int                  buildImage(const char *fn);

   private:
    static int buildImageHFork(AudioFileOp *afi,const char *fn);

   protected:
    virtual int processExited(void);
    virtual bool processStdoutLine(char *buf);

 };


#endif
