// KreateCD - CD recording software for the K desktop environment
//
// 1999 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include <qlist.h>

class ISOFile;


class ISOFile
 {

  public:
    enum ISOType {ISO_RealFile,ISO_RealDir,ISO_ISODir};


    ISOFile(ISOType type,class QString *name,class QString *reference=0);
    ~ISOFile(void);

    void addObject(class ISOFile *object);
    const class QString *name(void);
    const class QString *reference(void);
    ISOType              type(void);

    ISOFile *getChildren(ISOFile *walker=0);
    ISOFile *findChildren(const QString *name);

    bool createTree(const char *prefix);
    bool deleteTree(const char *prefix);

  private:

    ISOType            objectType;         // type of object
    class QString     *objectName;         // name of object
    class QString     *objectReference;    // reference to a real file
    QList<ISOFile>    *subObjects;
    class ISOFile     *parentObject;       // pointer to parent object
 };

typedef QList<ISOFile> ISOFileList;
