// KreateCD - CD recording software for the K desktop environment
//
// 1999 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include <qwidget.h>

class AudioOptions : public QWidget
 {
  Q_OBJECT;
  
 
  public:
    AudioOptions( QWidget *parent=0, const char *name=0,class CDTrack *track=0);
    ~AudioOptions(void);
    void hide(void);
 
  signals:
    void closed(void);
    void needUpdate(void);

  public slots:
    void sliderPress(void);
    void positionChanged(int frame);
    void sliderRelease(void);
    void sliderMove(int frame);
    void doPlayBegin(void);
    void doPlay(void);
    void doBackward(void);
    void doForward(void);
    void setStart(void);
    void setStop(void);

    void changeBoost(int boost);
    void changeBalance(int balance);

  private:
    class CDTrack     *ThisTrack;
    class AudioFile   *ThisAudio;
    class KSlider     *PlaySlider;
    class QSlider     *BalanceSlider;
    class QSlider     *VolumeSlider;

    class QPushButton *PlayButton,*StopButton,*SetStartButton,*SetStopButton;
    class QPushButton *ForwardButton,*BackwardButton,*PlayBeginButton;

    int                isPressed;
    long int           lastPosition;
    long int           absSize;
 };


