/***************************************************************************
                          tools.cpp  -  description
                             -------------------
    begin                : Sun Mar 4 2001
    copyright            : (C) 2001 by Kai Heitkamp
    email                : koncd@kai-heitkamp.de
 ***************************************************************************/

#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qmultilinedit.h>

#include <kapp.h>
#include <klocale.h>
#include <kconfig.h>
#include <kmessagebox.h>

#include "tools.h"
#include "cddata.h"

Tools::Tools(QWidget *parent, const char *name ) : Tools_GUI(parent,name) {
	//Read config
	KConfig *config = kapp->config();
	config->setGroup( "Config - tools" );

	QCheckBox_Eject->setChecked( config->readBoolEntry("QCheckBox_Eject") );
	QCheckBox_Force->setChecked( config->readBoolEntry("QCheckBox_Force") );
	QCheckBox_generateTOC->setChecked( config->readBoolEntry("QCheckBox_generateTOC") );

	QComboBox_CDRWBlanking->setCurrentItem( config->readNumEntry("QComboBox_CDRWBlanking") );
	QComboBox_WriterSpeed->setCurrentItem( config->readNumEntry("QComboBox_WriterSpeed") );
}

Tools::~Tools(){
}

//Starts the DeviceControl Tools
void Tools::slot_deviceReset(){
	CDdata *CD = new CDdata;
	CD->reset( 0 );
}

//---Start cdrecord---
void Tools::slot_start(){
	KConfig* config = kapp->config();

	QPushButton_Start->setEnabled( false );
	QPushButton_Quit->setEnabled( false );

	process.clearArguments();
	process << "cdrecord" << "-v";

	//Set the CD-Writer first
	config->setGroup("CD-Writer");
	process << config->readEntry("Device");

	//Set CD-Writer Options to KProcess
	if( QCheckBox_Eject->isChecked() ) process << "-eject";
	if( QCheckBox_Force->isChecked() ) process << "-force";
	if( QCheckBox_generateTOC->isChecked() ) process << "-fix";

	//Set CD-RW Options to KProcess
	switch( QComboBox_CDRWBlanking->currentItem() )
	{
	 	case 1:	process << "blank=all";
						break;
	 	case 2: process << "blank=fast";
						break;
	 	case 3: process << "blank=track";
						break;
	 	case 4: process << "blank=unreserve";
						break;
	 	case 5: process << "blank=trtrail";
						break;
	 	case 6: process << "blank=unclose";
						break;
		case 7: process << "blank=session";
						break;
	}

	//Set CD-Writer Speed to KProcess
	switch( QComboBox_WriterSpeed -> currentItem() )
	{
   	case 0:	process << "speed=1";
						break;
   	case 1:	process << "speed=2";
						break;
   	case 2:	process << "speed=4";
						break;
   	case 3:	process << "speed=6";
						break;
   	case 4:	process << "speed=8";
						break;
   	case 5:	process << "speed=10";
						break;
   	case 6:	process << "speed=12";
						break;
   	case 7:	process << "speed=16";
						break;
   	case 8:	process << "speed=20";
						break;
	}

	StatusLabel -> setText( i18n("Prepare for write...") );

	//Connect with slotRecStderr to update KProgress (Write- / Buffer-Status) and StatusLine
	connect( &process, SIGNAL(receivedStdout (KProcess *, char *, int) ), this, SLOT(slotRecStderr (KProcess *, char *, int) ));
	connect( &process, SIGNAL(receivedStderr (KProcess *, char *, int) ), this, SLOT(slotRecStderr (KProcess *, char *, int) ));

	//Connect the 'processExited' Signal to the 'slotProcessFinished' Slot
	connect( &process, SIGNAL(processExited(KProcess *)), this, SLOT(slotProcessExited(KProcess *)));

	//Start KProcess
	if( ! process.start( KProcess::NotifyOnExit, KProcess::AllOutput ) )
		{
		KMessageBox::error( 0, i18n("CD-Tools:\nCould not start cdrecord !") );
		return;
		}
}

//'RecStderr' for cdrecord
void Tools::slotRecStderr( KProcess *, char *buffer, int buflen ){
	char buf[1024];

	if( !buflen ) {
		return;
	}
	bzero( buf, sizeof( buf ) );
	strncpy( buf, buffer, buflen > (int) sizeof( buf ) ? sizeof(buf) - 1 : buflen );
	//Add cdrecord Messages to the Output-Window
	Output->insertLine( buf );
	//Go to the End of the Output-Text
	Output->setCursorPosition(Output->numLines(),0,false);

	if( strstr( buf, "Blanking" )) {
		StatusLabel -> setText( i18n("Blanking the CDRW...") );
	}

	if( strstr( buf, "Blanking time" )) {
		StatusLabel -> setText( i18n("Blanking-Process complete.") );
	}

	if( strstr( buf, "Fixating..." )) {
		StatusLabel -> setText( i18n("Writing TOC...") );
	}

	if( strstr( buf, "Fixating time:" )) {
		StatusLabel -> setText( i18n("Burn-Process complete.") );
   	}

}

//Process exited
void Tools::slotProcessExited( KProcess *rcproc ){
   int noperms = 13;		//Exitcode for no enough permissions
   int nodriver = 19;		//Exitcode for no driver
	int nocdr = 255;		//Exitcode for no CD-R in the Writer-Device
	int corruptcd = 254;	//Exitcode for corrupt CD in Writer-Device

	//KProcess did exit normally, it does have a valid exit status
	if( rcproc->exitStatus() != 0 )
		{
		QString statusout;
		statusout.sprintf( "\nError, exit status: %d\n", rcproc->exitStatus() );
		Output->insertLine( statusout );
		Output->setCursorPosition(Output->numLines(),0,false);
		StatusLabel -> setText( i18n( "An Error is occurred !" ) );
		if( rcproc->exitStatus() == nocdr ) StatusLabel -> setText( i18n( "Error: No CD-R(W) in the Writer-Device !" ) );
		if( rcproc->exitStatus() == corruptcd ) StatusLabel -> setText( i18n( "Error: Corrupt CD in the Writer-Device !" ) );
		if( rcproc->exitStatus() == noperms ) StatusLabel -> setText( i18n( "Error: You don't have enough permissions !" ) );
		if( rcproc->exitStatus() == nodriver ) StatusLabel -> setText( i18n( "Error: Can't open SCSI-Driver !" ) );
		}

	//If KProcess already running, kill it
	if( process.isRunning() ) process.kill();

	QPushButton_Start->setEnabled( true );
	QPushButton_Quit->setEnabled( true );
}

//'Abort-Button' clicked
void Tools::slot_abort(){
//	if( process.isRunning() ) process.kill();
//	QPushButton_Start->setEnabled( true );
}

//'Quit-Button' clicked
void Tools::slot_quit(){
	//Write config
	KConfig *config = kapp->config();
	config->setGroup( "Config - tools" );
	config->writeEntry( "QCheckBox_Eject", QCheckBox_Eject->isChecked() );
	config->writeEntry( "QCheckBox_Force", QCheckBox_Force->isChecked() );
	config->writeEntry( "QCheckBox_generateTOC", QCheckBox_generateTOC->isChecked() );

	config->writeEntry( "QComboBox_CDRWBlanking", QComboBox_CDRWBlanking->currentItem() );
	config->writeEntry( "QComboBox_WriterSpeed", QComboBox_WriterSpeed->currentItem() );

	close( true );
}
