#include "cdEditData.h"

#define slotLog

cdEditData::cdEditData(QWidget*     parent,
                       const char*  name,
		       T_cdTree*    EineCD)
	: QDialog( parent, name, TRUE ) 
{
        MeineCD   = EineCD;
	fEditiert = false;

	tmpQPushButton1 = new QPushButton( this, "PushButton_1" );
	tmpQPushButton1->setGeometry( 180, 350, 220, 30 );
	tmpQPushButton1->setText( i18n("Done") );
	tmpQPushButton1->setAutoRepeat( FALSE );
	tmpQPushButton1->setAutoResize( FALSE );

	tmpQFrame1 = new QGroupBox( i18n("Includes"), this);
	tmpQFrame1->setGeometry( 5, 5, 280, 335 );
    	// tmpQFrame1->setLineWidth(1);
	// tmpQFrame1->setFrameStyle( QFrame::Box | QFrame::Sunken );

	tmpQListBox1 = new QListBox( this, "ListBox_1" );
	tmpQListBox1->setGeometry( 10, 20, 270, 270 );
 	tmpQListBox1->setFrameStyle( 51 );
	tmpQListBox1->setLineWidth( 2 );

	tmpQPushButton2 = new QPushButton( this, "PushButton_2" );
	tmpQPushButton2->setGeometry( 170, 300, 100, 30 );
	tmpQPushButton2->setText( i18n("Remove") );
	tmpQPushButton2->setAutoRepeat( FALSE );
	tmpQPushButton2->setAutoResize( FALSE );
	tmpQPushButton2->setEnabled   ( FALSE );       

	tmpQFrame2 = new QGroupBox(i18n("Excludes"), this);
	tmpQFrame2->setGeometry( 295, 5, 280, 335 );
	// tmpQFrame2->setLineWidth(1);
	// tmpQFrame2->setFrameStyle( QFrame::Box | QFrame::Sunken );

	tmpQListBox2 = new QListBox( this, "ListBox_2" );
	tmpQListBox2->setGeometry( 300, 20, 270, 270 );
 	tmpQListBox2->setFrameStyle( 51 );
	tmpQListBox2->setLineWidth( 2 );

	DNDDirektaufnahme = new KDNDDropZone(tmpQListBox2, DndURL);

	tmpQPushButton3 = new QPushButton( this, "PushButton_3" );
	tmpQPushButton3->setGeometry( 320, 300, 100, 30 );
	tmpQPushButton3->setText( i18n("Add") );
	tmpQPushButton3->setAutoRepeat( FALSE );
	tmpQPushButton3->setAutoResize( FALSE );

	tmpQPushButton4 = new QPushButton( this, "PushButton_4" );
	tmpQPushButton4->setGeometry( 460, 300, 100, 30 );
	tmpQPushButton4->setText( i18n("Remove") );
	tmpQPushButton4->setAutoRepeat( FALSE );
	tmpQPushButton4->setAutoResize( FALSE );
	tmpQPushButton4->setEnabled   ( FALSE );       


	// Gre festlegen
	resize( 584, 390 );
	setMinimumSize(584, 390);
	setMaximumSize(584, 390);

	// Die Listboxen mit Daten fllen
	for (int Cnt= 0; Cnt < EineCD->getVerzNum(); Cnt++) 
	  {
	    string   temp1, 
	      temp2;
	    
	    EineCD->getVerz(Cnt, temp1, temp2);	    
	    if (temp1 != "dummydir")
	      {
		temp1 += " -> ";
		temp2.replace(0, 3, "");
		temp1 += temp2;
		tmpQListBox1->insertItem(temp1.c_str());
	      }
	    else
	      {
		temp2.replace(0, 3, "");
		tmpQListBox1->insertItem(temp2.c_str());
	      }
	  }
	for (int Cnt= 0; Cnt < EineCD->getExNum(); Cnt++) 
	  {
	    string temp;
	    
	    EineCD->getEx(Cnt, temp);
	    tmpQListBox2->insertItem(temp.c_str());
	  }
	
	connect(tmpQPushButton4, SIGNAL(clicked()), SLOT(removeFromRightLB()));
	connect(tmpQPushButton3, SIGNAL(clicked()), SLOT(addExcl()));
	connect(DNDDirektaufnahme,
		SIGNAL(dropAction(KDNDDropZone *)),
		SLOT(DDDirectCB(KDNDDropZone *)));
	connect(tmpQListBox2, SIGNAL(highlighted(int)), SLOT(highlightRightLB(int)));
	connect(tmpQPushButton2, SIGNAL(clicked()), SLOT(removeFromLeftLB()));
	connect(tmpQPushButton1, SIGNAL(clicked()), SLOT(accept()));
	connect(tmpQListBox1, SIGNAL(highlighted(int)), SLOT(highlightLeftLB(int)));
	
}

cdEditData::~cdEditData()
{
  delete tmpQFrame1;
  delete tmpQPushButton1;
  delete tmpQFrame2;
  delete tmpQListBox1;
  delete tmpQListBox2;
  delete tmpQPushButton2;
  delete tmpQPushButton3;
  delete tmpQPushButton4;
  delete DNDDirektaufnahme;
}


void cdEditData::highlightLeftLB(int welche)
{
#ifdef slotLog
  cerr << "slot: highlightLeftLB\n";
  cerr.flush();
#endif
  tmpQPushButton2->setEnabled(true);
}

void cdEditData::highlightRightLB(int welche)
{
#ifdef slotLog
  cerr << "slot: highlightRightLB\n";
  cerr.flush();
#endif
  tmpQPushButton4->setEnabled(true);
}

void cdEditData::removeFromLeftLB()
{
#ifdef slotLog
  cerr << "slot: removeFromLeftLB\n";
  cerr.flush();
#endif
  MeineCD->Remove(tmpQListBox1->currentItem());
  tmpQListBox1->removeItem(tmpQListBox1->currentItem());
  // Wenn jetzt kein Eintrag mehr vorhanden ist, Button disablen:
  if (MeineCD->getVerzNum() == 0) tmpQPushButton2->setEnabled(false);
  fEditiert = true;
}

void cdEditData::removeFromRightLB()
{
#ifdef slotLog
  cerr << "slot: removeFromRightLB\n";
  cerr.flush();
#endif
  MeineCD->removeEx(tmpQListBox2->currentItem());
  tmpQListBox2->removeItem(tmpQListBox2->currentItem());
  // Wenn jetzt kein Eintrag mehr vorhanden ist, Button disablen:
  if (MeineCD->getExNum() == 0) tmpQPushButton4->setEnabled(false);
  fEditiert = true;
}

void cdEditData::DDDirectCB(KDNDDropZone* _dropZone)
{
#ifdef slotLog
  cerr << "slot: DDDirectCB\n";
  cerr.flush();
#endif
  string dropped = _dropZone->getData();

  if (dropped.find("file:") == string::npos) {
    fehlermeldung(i18n("You can only drop local files and dirs!\n"));
  }
  else {
    dropped.replace(0, 5, "");

    if (dropped[dropped.size()-1] != '/') {
      // es ist eine Datei, nur den Namen aufnehmen (wird mit -m ausgeschlossen; gilt
      // dann als Muster fr alle Dateien/Verzeichnisse!)
      while (dropped.find("/") != string::npos) { 
	dropped.replace(0, 1, "");
      }
    }
    else {
      fehlermeldung(i18n("WARNING\nUsing the mkisofs-option -x (to exclude dirs) did not\nseem to work on my system (mkisofs 1.12b3)"));
    }
    

    if (MeineCD->Exclude(dropped) == 0) {
      tmpQListBox2->insertItem(dropped.c_str());      
      fEditiert = true;
    }
  }
}

void cdEditData::addExcl()
{
#ifdef slotLog
  cerr << "slot: addExcl\n";
  cerr.flush();
#endif
  neuVerzDiag tmpDiag(this, 
		      "einName", 
		      "~#*0123456789_-.abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ/", 
		      i18n("Here you can give me an expression which describes files and directories to be excluded, like 'emil', '*tmp*', '*.bak', '~otto*'...(no wildcard, wildcard ('*') at the beginning and/or at the end). Whitespaces at the beginning and at the end are removed.\n\nYou can also drop files/dirs into the 'Excludes'-box!"), 
		      "");
  if (tmpDiag.exec() == QDialog::Accepted) {
    string aTemp = tmpDiag.tmpQLineEdit->text();
    
    // Leerzeichen vorn und hinten wegschneiden, wenn der String dann ungleich null ist,
    // anfgen:
    while ((aTemp[0] == ' ') && (aTemp.size() != 0)) { 
      aTemp.replace(0, 1, ""); 
    } 
    while ((aTemp[aTemp.size()-1] == ' ') && (aTemp.size() != 0)) { 
      aTemp.replace(aTemp.size()-1, 1, ""); 
    }
    if (aTemp.size() != 0) {
      if (MeineCD->Exclude(aTemp) == 0) {
	tmpQListBox2->insertItem(aTemp.c_str());      
	fEditiert = true;
      }
    }
  }
}

#include "cdEditData.moc"









