/***************************************************************************
                          keasycddoc.h  -  description                              
                             -------------------                                         
    begin                : Sun Feb  7 09:35:03 MET 1999
                                           
    copyright            : (C) 1999 by Marcel Borred                         
    email                : marcel.borreda@post.rwth-aachen.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef KEASYCDDOC_H 
#define KEASYCDDOC_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qobject.h>
#include <qfile.h>
#include <kfiledialog.h>
#include <kmsgbox.h>


/** 
  * This class provides base functionality for your application document
  * such as file creation, saving and closing by serialization of a QFile
  * Object.
  */
class KEasyCDDoc : public QObject
{
  Q_OBJECT

 public:
  /** Constructor for the fileclass of the application */
  KEasyCDDoc(QObject*, const char *filename=0L);
  /** Destructor for the fileclass of the application */
  ~KEasyCDDoc();
  /** returns the value of the modified flag*/
  bool isModified() {return bModified;};
  /** deletes the current document contents */
  void deleteContents();
  /** saves the document to a file. If a file already exists and is created, it
    * saves directly to the file; otherwise it asks for a filename. */
  void saveFile();
  /** opens the file after a file is selected */
  void openFile();


  public slots:
    /** sets the modified flag */
    void setModified(bool m= true);

 private:
  /** modified flag: true, if actual view is modified */
  bool bModified;


};

#endif // KEASYCDDOC_H




