#ifndef _KCDWRITE_PLAYPANEL_H
#define _KCDWRITE_PLAYPANEL_H

/*********************************************************************************
 *
 * $Id $
 *
 * 
 *
 */


#include <qwidget.h>
#include <qlabel.h>
#include "bwlednum.h"
#include <qpushbt.h>
#include "ocdrom.h"

/**
   CdPlayPanel implements a widget which provides buttons to give the user
   control about Cdrom s audio-functions.
   This means: a play-button, a pause-button, two skip-buttons etc.
 */
class CdPlayPanel : public QWidget
{
  Q_OBJECT

 public:
  enum CdPanelStatus { Ready, NotReady, NewCd };

  CdPlayPanel( Cdrom *aCdrom, QWidget *parent=0 );
  virtual ~CdPlayPanel();
  
  virtual QSize sizeHint() const;
  virtual void timerEvent( QTimerEvent *e );
  void updateDisplay();
  void lock( bool lockNow );
  bool isLocked(); 

 public slots:
  void disable();
  void enable();

  void playPressed();
  void stopPressed();
  void nextPressed();
  void prevPressed();
  void ejectPressed();

 signals:
  void play( int track );
  void stop();
  void pause();
  void skip( int newTrack );
  void volume( int newVolume );
  void statusChange( CdPanelStatus status );
  void lockFault();

 protected:
  CdPanelStatus oldStatus;
  int curTrack;

  BW_LED_Number *make_BW_LED( int x, char *name = 0 ); 

  QPushButton *playPB;
  QPushButton *stopPB;
  QPushButton *nextPB;
  QPushButton *prevPB;
  QPushButton *ejectPB;
  
  BW_LED_Number *infoMin1;
  BW_LED_Number *infoMin2;
  BW_LED_Number *infoSec1;
  BW_LED_Number *infoSec2;
  QLabel *infoStatus;
  QLabel *infoTrack;
  Cdrom *cdrom;
  bool _locked;
};

#endif
