/* 
 * main.cpp 
 * 
 * Copyright (C) 1999 Tomislav Gountchev <tomi@socrates.berkeley.edu>
 */


// using framework created by kapptemplate 0.3

#include <qstring.h>
#include "kmol.h"
#include <kapp.h>
#include "kmolcalc.h"
#include "kmolelements.h"
#include <stdio.h>

int main(int argc, char *argv[])
{
	KApplication app(argc, argv, "kmol");

	if (argc != 1) {  // called with a command line argument(s), no GUI please.
	  KMolCalc* kmolcalc = new KMolCalc;
	  double w;
	  for (int i = 1; i < argc; i++) {
	    QString* errors = kmolcalc->readFormula(QString(argv[i]));
	    if (errors == NULL && (w = kmolcalc->getWeight()) > 0) 
	      printf("%s:   Mw = %f, %s\n\n%s \n\n\n", 
		     argv[i], w, 
		     kmolcalc->getEmpFormula().data(),
		     kmolcalc->getEA().data());
	    else 
	      printf(" ??? ERROR: %s\n\n", errors->data());
	  }
	  exit(0);
	}
	
	// All session management is handled in the RESTORE macro
	if (app.isRestored())
	  {
		RESTORE(KMol)
	}
	else
	{
		KMol *widget = new KMol;
		widget->show();
	}

	return app.exec();
}
