/***************************************************************************
                          treeview.h  -  description
                             -------------------
    begin                : Wed Feb 23 2000
    copyright            : (C) 2000 by Yacovlev Alexander & Dmitry Poplavski
    email                : pdima@mail.univ.kiev.ua
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TREEVIEW_H
#define TREEVIEW_H

#include <qwidget.h>
#include <qlistview.h>

/**view tree
  *@author Yacovlev Alexander & Dmitry Poplavski
  */

class QPopupMenu;
class Directory;
class QStrList;

class TreeView : public QListView  {
   Q_OBJECT
public:
		TreeView( QPixmap pix,const char *text,const char *_dir, QWidget * parent = 0, QStrList* topList = 0 );
		~TreeView();
	  /** popup menu on right button mouse */
public slots:
    /** slot for right menu */
    virtual void slotRightMenu(QListViewItem*, const QPoint&, int);
public:
    /** main directory */
    Directory *mainDir;
    /** menus on right click mouse */
		QPopupMenu *rightMenuOp;
		QPopupMenu *rightMenuCl;
		QPopupMenu *rightMenuTopOp;
		QPopupMenu *rightMenuTopCl;
		QStrList * topList; // list of dir names added to top of the tree
public slots: // Public slots
  /** add folder to top */
  void slotAddToTop();
  /** open folder */
  void slotFolderOpen();
  /** close folder */
  void slotFolderClose();
  /** remove top item from the tree */
  void slotRemFromTop();
};

#endif
