/***************************************************************************
                          treeview.cpp  -  description
                             -------------------
    begin                : Wed Feb 23 2000
    copyright            : (C) 2000 by Yacovlev Alexander & Dmitry Poplavski
    email                : pdima@mail.univ.kiev.ua
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "treeview.h"
#include "resource.h"

#include "dirview.h"

#include <kapp.h>
#include <qdir.h>
#include <kdir.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qpixmap.h>
#include <qheader.h>
#include <qstrlist.h>


#include "pics/folder.xpm"
#include "pics/folder_open.xpm"
#include "pics/project_folder.xpm"

TreeView::TreeView (QPixmap pix,const char *text,const char *_dir,QWidget * parent = 0, QStrList* topList)
  :QListView(parent,0)
{
  this->topList = topList;
  setRootIsDecorated( true );
  header()->hide();
  setSorting(-1,false);

  setFrameStyle( Panel | Sunken );
  setLineWidth( 2 );
  addColumn( "Name" );
	
	mainDir = new Directory( this ,text,_dir);
	mainDir->setPixmap( 0, pix );
	mainDir->setOpen( true);
	
	setFocusPolicy(QWidget::ClickFocus);
	
	
	for ( char *fName=topList->first(); fName != 0; fName=topList->next() ) {
	
	  char *fname = new char[256];
    strncpy(fname, fName ,255);
	
	  Directory *dir = new Directory( this , fname, fname);
	  dir->setPixmap( 0, QPixmap((const char**)project_folder_xpm) );
	  dir->setOpen( false);
	}
	
	
	rightMenuOp = new QPopupMenu();
	rightMenuOp -> insertItem( i18n("&Add folder to top"),
	  this,SLOT(slotAddToTop()), ID_TREE_ADDTOTOP);
	rightMenuOp -> insertSeparator();
	rightMenuOp -> insertItem( QPixmap((const char**)folder_open_xpm),i18n("&Open folder"),
	  this,SLOT(slotFolderOpen()), ID_TREE_OPEN);

	rightMenuCl = new QPopupMenu();
	rightMenuCl -> insertItem( i18n("&Add folder to top"),
	  this,SLOT(slotAddToTop()), ID_TREE_ADDTOTOP);
	rightMenuCl -> insertSeparator();
	rightMenuCl -> insertItem( QPixmap((const char**)folder_xpm), i18n("&Close folder"),
	  this,SLOT(slotFolderClose()), ID_TREE_CLOSE);
	
	rightMenuTopOp = new QPopupMenu();
	rightMenuTopOp -> insertItem( i18n("&Remove from tree"),this,
	                              SLOT(slotRemFromTop()), ID_TREE_REMOVE);
	rightMenuTopOp -> insertSeparator();
	rightMenuTopOp -> insertItem( QPixmap((const char**)folder_open_xpm),i18n("&Open folder"),
                            	  this,SLOT(slotFolderOpen()), ID_TREE_OPEN);
	
	rightMenuTopCl = new QPopupMenu();
	rightMenuTopCl -> insertItem( i18n("&Remove from tree"),this, SLOT(slotRemFromTop()), ID_TREE_REMOVE);
	rightMenuTopCl -> insertSeparator();
	rightMenuTopCl -> insertItem( QPixmap((const char**)folder_xpm), i18n("&Close folder"),
	  this,SLOT(slotFolderClose()), ID_TREE_CLOSE);
	
	connect( this, SIGNAL(rightButtonPressed(QListViewItem*, const QPoint&, int)),
					       SLOT(slotRightMenu(QListViewItem*, const QPoint&, int)));
					
}

TreeView::~TreeView()
{
}

/** slot for right menu */
void TreeView::slotRightMenu(QListViewItem *item, const QPoint& point, int){

  Directory *d = dynamic_cast<Directory *>( item);
  if ( d ) {
    setSelected(item, TRUE);
    if ( d->p) {
      if ( d->opened ) rightMenuCl->popup( point);
	    else rightMenuOp->popup( point);
    } else {

      if ( d == mainDir ) {
         rightMenuTopOp->setItemEnabled(ID_TREE_REMOVE, false);
         rightMenuTopCl->setItemEnabled(ID_TREE_REMOVE, false);
      }
      else {
         rightMenuTopOp->setItemEnabled(ID_TREE_REMOVE, true);
         rightMenuTopCl->setItemEnabled(ID_TREE_REMOVE, true);
      }

     if ( d->opened ) rightMenuTopCl->popup( point);
	    else rightMenuTopOp->popup( point);
    }
  }
}


/** open folder */
void TreeView::slotFolderOpen(){
  Directory *d = dynamic_cast<Directory *>( currentItem());
  if ( d ) {
    d->setOpen( true);
  }
}

/** close folder */
void TreeView::slotFolderClose(){
  Directory *d = dynamic_cast<Directory *>( currentItem());
  if ( d ) {
    d->setOpen( false);
  }
}

/** add folder to top */
void TreeView::slotAddToTop(){
  Directory *d = dynamic_cast<Directory *>( currentItem());
  if ( d ) {
    //d->setOpen( false);
    char *fname = new char[256];
    strncpy(fname, d->fullName(),255);
    Directory *dir = new Directory( this , fname, fname);
	  dir->setPixmap( 0, QPixmap((const char**)project_folder_xpm) );
	  dir->setOpen( false);
	  topList->append(fname);
  }
}

/** remove top item from the tree */
void TreeView::slotRemFromTop(){

  Directory *d = dynamic_cast<Directory *>( currentItem());

  if ( d!=mainDir ) {
    char *fname = new char[256];
    strncpy(fname, d->fullName(),255);
 	  int ind = topList->find(fname);
	  if ( ind != -1 )
      topList->remove(ind);
    delete(d);
  }
}
