/***************************************************************************
                          doctreeview.cpp  -  description
                             -------------------
    begin                : Sat Mar 4 2000
    copyright            : (C) 2000 by Yacovlev Alexander & Dmitry Poplavsky
    email                : pdima@mail.univ.kiev.ua
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "doctreeview.h"
#include "docfolder.h"
#include "docitem.h"
#include <kconfig.h>
#include <qlistview.h>
#include <kapp.h>
#include <qstrlist.h>
#include <qheader.h>
#include <qpixmap.h>

#include "pics/folder_open.xpm"

DocTreeView::DocTreeView(QWidget *parent, const char *name )
  : QListView(parent,0)
{
  KConfig *config = new KConfig( kapp->kde_datadir()+"/quanta/doc.rc" );
  config->sync();
  config->setGroup("Tree");

  setRootIsDecorated( true );
  header()->hide();
  setSorting(-1,false);

  setFrameStyle( Panel | Sunken );
  setLineWidth( 2 );
  addColumn( "Name" );

  mainDoc = new DocFolder( this, QString("Documentation"), config);
  mainDoc->setPixmap( 0, QPixmap((const char**)folder_open_xpm) );
  mainDoc->main = true;
  mainDoc->setOpen( true );

  setFocusPolicy(QWidget::ClickFocus);
}


DocTreeView::~DocTreeView(){
}

