/*************************************************************
*
* (c) 1999, 2000 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#include "wholder.h"
#include "wholder.moc"

/*******************************************************************************
	class ptWidget:
********************************************************************************/

ptWidget::ptWidget( QWidget *parent ) : QWidget(parent)
{
	setPalette( QPalette( QColor( 0, 0, 0 ) ) );

	moveMode = false;

	mX = 0; mY = 0;


}

void ptWidget::showIt( bool isActive = false )
{
	if (isActive)
		setPalette( QPalette( QColor( 255, 0, 0 ) ) );
	else
		setPalette( QPalette( QColor( 0, 0, 0 ) ) );

	show();
}


void ptWidget::setActive( bool isActive )
{
	if (isActive)
	{
		setPalette( QPalette( QColor( 255, 0, 0 ) ) );
		raise();
	}
	else
		setPalette( QPalette( QColor( 0, 0, 0 ) ) );
}


void ptWidget::mousePressEvent( QMouseEvent *e )
{

	if (moveMode)
	{
		moveMode = false;
		emit mReject();
		return;
	}

	if ( e->button() != LeftButton )
		return;

	mX = x() - e->globalX();
	mY = y() - e->globalY();


	moveMode = true;
}


void ptWidget::mouseReleaseEvent( QMouseEvent *e )
{
	moveMode = false;
	emit mr();
}


void ptWidget::mouseMoveEvent( QMouseEvent *e )
{
	if (!moveMode) return;

	move( e->globalX() + mX, e->globalY() + mY );

	emit moved( e->globalX() + mX+3, e->globalY() + mY+3 );
}



/*******************************************************************************
	class widgetHolder:
********************************************************************************/

widgetHolder::widgetHolder( widgetHolder *parent ) : QWidget( (QWidget*)parent )
{
	myParent = (QWidget *) parent;
	whParent = parent;

	constr();
}

widgetHolder::widgetHolder( QWidget *parent ) : QWidget(parent)
{
	myParent = parent;
	whParent = 0L;

	constr();
}

void widgetHolder::constr()
{
int i;

	//This is only for if I am a window or sub window with own vars, etc:
	for ( i = 0; i < 512; i++ )
	{
		rVars[0][i] = "";
		rConsts[0][i] = "";
		rFuncs[0][i] = "";

		rVars[1][i] = "";
		rConsts[1][i] = "";
		rFuncs[1][i] = "";
	}

	nResult = false;

	tool = ID_NO_TOOL;

	allowSubs = false;
	moveMode = false;
	sMode = false;

	haveXY = true;

	ownType = -1;

	mX = 0; mY = 0;
	sX = 0; sY = 0;

	for ( i = 0; i < 100; i++ )
	{
		props[0][i] = "";
		props[1][i] = "";
	}

	setFocusPolicy( QWidget::StrongFocus );


	activeZP = 0;

	for ( i = 0; i < 8; i++ )
	{
		zoomPoints[i] = new ptWidget(myParent);
		zoomPoints[i]->hide();

		connect( zoomPoints[i], SIGNAL(mr()), SLOT(moveOK()) );
		connect( zoomPoints[i], SIGNAL(mReject()), SLOT(moveCancel()) );
	}

	connect( zoomPoints[0], SIGNAL(moved(int,int)), SLOT(moveP1(int,int)) );
	connect( zoomPoints[1], SIGNAL(moved(int,int)), SLOT(moveP2(int,int)) );
	connect( zoomPoints[2], SIGNAL(moved(int,int)), SLOT(moveP3(int,int)) );
	connect( zoomPoints[3], SIGNAL(moved(int,int)), SLOT(moveP4(int,int)) );
	connect( zoomPoints[4], SIGNAL(moved(int,int)), SLOT(moveP5(int,int)) );
	connect( zoomPoints[5], SIGNAL(moved(int,int)), SLOT(moveP6(int,int)) );
	connect( zoomPoints[6], SIGNAL(moved(int,int)), SLOT(moveP7(int,int)) );
	connect( zoomPoints[7], SIGNAL(moved(int,int)), SLOT(moveP8(int,int)) );


} //constructor


void widgetHolder::getProperties( QString ps[], QString vs[] )
{
int i;

	for ( i = 0; i < 100; i++ )
	{
		if ( props[0][i] == "" ) break;

		ps[i].setStr( props[0][i] );
		vs[i].setStr( props[1][i] );

	}

	ps[i].setStr( "" );
}


void widgetHolder::move( int xP, int yP )
{
	//I need this function, since "move" must also cause a resizeEvent
	setGeometry( xP, yP, width(), height() );
}

void widgetHolder::buildProperties( QString prop[], QString val[] )
{

	for ( int i = 0; prop[i] != ""; i++ )
	{
		if ( i == 98 )
			fatal( "Too many properties (Internal error)" );

		props[0][i] = prop[i];
		props[1][i] = val[i];

	}
}


/*
void widgetHolder::setVars( QString n[], QString v[] )
{
int i;

	for ( i = 0; i < 512; i++ )
	{
		rVars[0][i] = n[i];
		rVars[1][i] = v[i];
	}

}


void widgetHolder::setConsts( QString n[], QString v[] )
{
int i;

	for ( i = 0; i < 512; i++ )
	{
		rConsts[0][i] = n[i];
		rConsts[1][i] = v[i];
	}
}


void widgetHolder::setFuncs( QString n[], QString v[] )
{
int i;

	for ( i = 0; i < 512; i++ )
	{
		rFuncs[0][i] = n[i];
		rFuncs[1][i] = v[i];
	}
}*/


QString *widgetHolder::getVarNames()
{
	return( rVars[0] );
}


QString *widgetHolder::getConstNames()
{
	return( rConsts[0] );
}


QString *widgetHolder::getFuncNames()
{
	return( rFuncs[0] );
}


QString *widgetHolder::getVarVals()
{
	return( rVars[1] );
}


QString *widgetHolder::getConstVals()
{
	return( rConsts[1] );
}


QString *widgetHolder::getFuncVals()
{
	return( rFuncs[1] );
}


void widgetHolder::forceNameCheck()
{
QString actualName;
QString hStr;
int i, ii = 1;

	for( i = 0; props[0][i] != "Name"; i++ )
		if( i == 99 )
			fatal( "In widgetHolder::forceNameCheck() : No name avaible." );

	actualName = props[1][i];

	emit testName( actualName, this );

	while( nResult )
		emit testName( actualName = props[1][i] +hStr.setNum(ii++), this );

	changeProperty( "Name", actualName );

}


void widgetHolder::changeProperty( QString prop, QString val ) //SLOT
{
int i;

	emit modified();

	for ( i = 0; i < 100; i++ )
		if ( props[0][i].lower() == prop.lower() )
		{
			props[1][i] = val;
			newProperties( props[0], props[1] );
			return;
		}

	fatal( "In widgetHolder::changeProperty(...): Illegal property \"%s\" (Internal error).",
		(const char*)prop );

}


void widgetHolder::setImage( QPixmap pix )
{
	myPix = pix;

	redraw();
}


void widgetHolder::redraw()
{
QPainter p;

	p.begin(this);

	p.drawPixmap(0,0,myPix);

	p.end();
}


void widgetHolder::paintEvent( QPaintEvent * )
{
	redraw();
}


void widgetHolder::resetZPs()
{

	zoomPoints[0]->setGeometry( x()-3, y()-3, 6, 6 );
	zoomPoints[1]->setGeometry( x()+(width()/2)-3, y()-3, 6, 6 );
	zoomPoints[2]->setGeometry( x()+width()-3, y()-3, 6, 6 );

	zoomPoints[3]->setGeometry( x()+width()-3, y()+(height()/2)-3, 6, 6 );

	zoomPoints[4]->setGeometry( x()+width()-3, y()+height()-3, 6, 6 );
	zoomPoints[5]->setGeometry( x()+(width()/2)-3, y()+height()-3, 6, 6 );
	zoomPoints[6]->setGeometry( x()-3, y()+height()-3, 6, 6 );

	zoomPoints[7]->setGeometry( x()-3, y()+(height()/2)-3, 6, 6 );

}


void widgetHolder::runSrcEdit( QString eStr )
{
int i;
QString srcPath = "", defCont;
widgetHolder *tmpPar;
QString ps[100], vs[100];
QDir d;


	for ( i = 0; props[0][i] != "Name"; i ++ )
		if ( i == 98 )
			fatal( "Missing \"Name\" property." );

	if( ownType != ID_WIN && ownType != ID_WID )
		eStr = QString(  props[1][i] +"_" +eStr );

	if( ownType == ID_WID || ownType == ID_WIN )
		tmpPar = this;
	else
		tmpPar = whParent;

	while( tmpPar != 0L )
	{
		tmpPar->getProperties( ps, vs );

		for ( i = 0; ps[i] != "Name"; i++ )
		{
			if ( i == 99 || ps[i] == "" )
				fatal ( "In winedit::nameOf(...): Unexpected internal error." );

		}

		srcPath = vs[i] +srcPath;

		tmpPar = tmpPar->getWhParent();

		if( tmpPar != 0L )
			srcPath = "_" +srcPath;
	}

	defCont = "Event " +eStr + "()\n{\n\n}\n";

	eStr = srcPath +"/" +eStr +".vk";
	eStr = eStr.lower();

	emit( showEvent( eStr, defCont ) );

}


void widgetHolder::resizeEvent( QResizeEvent * )
{
QString hStr;
int xx, yy, w, h;

	resetZPs();

	w = width(); h = height();
	xx = x(); yy = y();

	if(haveXY)
	{
		changeProperty( "x", hStr.setNum(xx) );
		changeProperty( "y", hStr.setNum(yy) );
	}

	changeProperty( "Width", hStr.setNum(w) );
	changeProperty( "Height", hStr.setNum(h) );

	emit mr();
}


void widgetHolder::focusInEvent( QFocusEvent * )
{

	for ( int i = 0; i < 8; i++ )
	{
		if ( i == activeZP )
			zoomPoints[i]->showIt(true);
		else
			zoomPoints[i]->showIt(false);
	}

	zoomPoints[activeZP]->raise();
}


void widgetHolder::focusOutEvent( QFocusEvent * )
{
	for ( int i = 0; i < 8; i++ )
		zoomPoints[i]->hide();

	resetZPs();
}


void widgetHolder::mousePressEvent( QMouseEvent *e )
{
int i;

	if ( !allowSubs ) emit resetTool();

	if ( e->button() == LeftButton )
	{

		if ( tool == ID_NO_TOOL || !allowSubs )
		{
			mX = x() - e->globalX();
			mY = y() - e->globalY();

			moveMode = true;
		}
		else
		{
			sX = e->x();
			sY = e->y();

			for ( i = 0; i < 4; i++ )
			{
				sLines[i] = new QWidget(this);
				sLines[i]->setPalette( QColor(0,0,0) );

				sLines[i]->resize(1,1);
			}

			sMode = true;
		}

		return;

	}


	if ( e->button() == RightButton )
	{
		setFocus();

		emenu = new KPopupMenu("Events");

		switch( ownType )
		{
			case ID_WIN:
				emenu->insertItem( "start()", this,
					SLOT(editEStart()) );
				emenu->insertItem( "click()", this,
					SLOT(editEClick()) );
				break;

			case ID_WID:
				emenu->insertItem( "start()", this,
					SLOT(editEStart()) );
				emenu->insertItem( "click()", this,
					SLOT(editEClick()) );
				break;

			case ID_BUTTON:
				emenu->insertItem( "click()", this,
					SLOT(editEClick()) );
				break;

			case ID_LABEL:
				emenu->insertItem( "click()", this,
					SLOT(editEClick()) );
				break;

			case ID_PIXLABEL:
				emenu->insertItem( "click()", this,
					SLOT(editEClick()) );
				break;

			case ID_EDITW:
				emenu->insertItem( "changed()", this,
					SLOT(editEChanged()) );
				emenu->insertItem( "return()", this,
					SLOT(editEReturn()) );
				break;

			case ID_LIST:
				emenu->insertItem( "changed()", this,
					SLOT(editEChanged()) );
				break;

			case ID_CHECKW:
				emenu->insertItem( "click()", this,
					SLOT(editEClick()) );
				break;

			case ID_OPTIONW:
				emenu->insertItem( "click()", this,
					SLOT(editEClick()) );
				break;

			case ID_SLIDER:
				emenu->insertItem( "changed()", this,
					SLOT(editEChanged()) );
				break;

			case ID_PROCCTRL:
				emenu->insertItem( "changed()", this,
					SLOT(editEChanged()) );
				emenu->insertItem( "exit()", this,
					SLOT(editEExited()) );
				break;

		}

		menu = new KPopupMenu();

		for ( i = 0; props[0][i] != "Name"; i ++ )
			if ( i == 98 )
				fatal( "Missing \"Name\" property." );

		menu->setTitle ( props[1][i] );

		menu->insertItem( "&Edit properties...", this, SLOT(editProps()) );
		menu->insertItem( "Edit e&vents", emenu );
		menu->insertSeparator();

		if( ownType != ID_WIN )
		{
			menu->insertItem( "&Delete", this, SLOT(emitDel()) );
			menu->insertSeparator();
		}

		menu->insertItem( "&Help on this widget" );

		menu->popup( QPoint( e->globalX(), e->globalY() ) );
	}

} //mousePressEvent(...)


void widgetHolder::mouseMoveEvent( QMouseEvent *e )
{
int nSx, nSy, nEx, nEy;

	if (moveMode)
	{
		nEx = e->globalX() +mX;
		nEy = e->globalY() +mY;

		move( nEx, nEy );
	}

	if (sMode)
	{
		if ( sX < e->x() )
		{
			nSx = sX;
			nEx = e->x();

			if ( nEx < 0 ) nEx = 0;
			if ( nEx > width() ) nEx = width();
		}
		else
		{
			nSx = e->x();
			nEx = sX;

			if ( nSx < 0 ) nSx = 0;
			if ( nSx > width() ) nSx = width();
		}

		if ( sY < e->y() )
		{
			nSy = sY;
			nEy = e->y();

			if ( nEy < 0 ) nEy = 0;
			if ( nEy > height() ) nEy = height();
		}
		else
		{
			nSy = e->y();
			nEy = sY;

			if ( nSy < 0 ) nSy = 0;
			if ( nSy > height() ) nSy = height();
		}

		fp = new QPoint( nSx, nSy );
		sp = new QPoint( nEx, nEy );

		sLines[0]->setGeometry( nSx, nSy, nEx -nSx, 2 );
		sLines[0]->show();

		sLines[1]->setGeometry( nEx, nSy, 2, nEy -nSy );
		sLines[1]->show();

		sLines[2]->setGeometry( nSx, nEy, nEx -nSx, 2 );
		sLines[2]->show();

		sLines[3]->setGeometry( nSx, nSy, 2, nEy -nSy );
		sLines[3]->show();
	}

}


void widgetHolder::mouseReleaseEvent( QMouseEvent *e )
{
int i;

	if (moveMode)
	{
		moveMode = false;
	}

	if (sMode)
	{
		sMode = false;

		for ( i = 0; i < 4; i++ )
			delete sLines[i];

		emit newWidget( fp->x(), fp->y(), sp->x(), sp->y(), this );
	}

}


void widgetHolder::keyPressEvent( QKeyEvent *e )
{
	if( e->key() == Key_Delete )
		emit deleteMe(this);

	if( e->key() == Key_Escape ) //Simulate right click
		mousePressEvent( new QMouseEvent( Event_MouseButtonPress,
		pos(), RightButton, RightButton ) );
}


void widgetHolder::editProps() //SLOT
{
        if( ownType == ID_LABEL || ownType == ID_PROCCTRL )
		//(Multi lined caption)
		pedi = new propEditDialog( props[0], props[1], true );
	else
		pedi = new propEditDialog( props[0], props[1] );

	connect( pedi, SIGNAL( changed(QString,QString)  ),
		SLOT( changeProperty(QString,QString) ) );

	connect( pedi, SIGNAL( checkName(QString) ), SLOT( checkName(QString) ) );

	connect( this, SIGNAL( nameOk(bool) ), pedi, SLOT( nameOk(bool) ) );

	pedi->show();

	delete pedi;
}

void widgetHolder::editEStart() //SLOT
{
	runSrcEdit( "start" );
}

void widgetHolder::editEClick() //SLOT
{
	runSrcEdit( "click" );
}

void widgetHolder::editEChanged() //SLOT
{
	runSrcEdit( "changed" );
}

void widgetHolder::editEReturn() //SLOT
{
	runSrcEdit( "return" );
}

void widgetHolder::editEExited() //SLOT
{
	runSrcEdit( "exit" );
}

void widgetHolder::checkName(QString n) //SLOT
{
	emit testName( n, this );

	emit nameOk(!nResult);
}


void widgetHolder::moveP1( int nx, int ny ) //SLOT
{
bool otherMove = false;

	if ( nx > x() +width() -5 )
	{
		otherMove = true;
		nx = x() +width() -5;
	}


	if ( ny > y() +height() -5 )
	{
		otherMove = true;
		ny = y() +height() -5;
	}

	if ( otherMove )
		zoomPoints[0]->move( nx-3, ny-3 );


	zoomPoints[1]->move( nx +(x()+width()-nx)/2 -3, ny-3 );
	zoomPoints[2]->move( x()+width()-3, ny-3 );

	zoomPoints[3]->move( x()+width()-3, ny +( y()+height()-ny)/2 -3 );

	//[4] is fix point
	zoomPoints[5]->move( nx +(x()+width()-nx)/2 -3, y() +height() -3 );
	zoomPoints[6]->move( nx -3, y()+height()-3 );

	zoomPoints[7]->move( nx -3, ny +( y()+height()-ny)/2 -3 );

	zoomPoints[activeZP]->setActive(false);

	activeZP = 0;
	zoomPoints[0]->setActive(true);

} //moveP1(...)


void widgetHolder::moveP2( int nx, int ny ) //SLOT
{
bool otherMove = false;

	if ( nx != x() +(width()/2) )
	{
		otherMove = true;
		nx = x() +width()/2;
	}


	if ( ny > y() +height() -5 )
	{
		otherMove = true;
		ny = y() +height() -5;
	}

	if ( otherMove )
		zoomPoints[1]->move( nx-3, ny-3 );


	zoomPoints[0]->move( x() -3, ny -3 );

	zoomPoints[2]->move( x()+width()-3, ny -3 );

	zoomPoints[3]->move( x()+width()-3, ny +( y()+height()-ny)/2 -3 );

	//[4]-[6] are fix points

	zoomPoints[7]->move( x() -3, ny +( y()+height()-ny)/2 -3 );

	zoomPoints[activeZP]->setActive(false);

	activeZP = 1;
	zoomPoints[1]->setActive(true);
	
} //moveP2(...)


void widgetHolder::moveP3( int nx, int ny ) //SLOT
{
bool otherMove = false;

	if ( nx < x() +5 )
	{
		otherMove = true;
		nx = x() +5;
	}


	if ( ny > y() +height() -5 )
	{
		otherMove = true;
		ny = y() +height() -5;
	}

	if ( otherMove )
		zoomPoints[2]->move( nx-3, ny-3 );


	zoomPoints[0]->move( x() -3, ny -3 );
	zoomPoints[1]->move( x() +(nx-x())/2 -3, ny-3 );

	zoomPoints[3]->move( nx -3, ny +( y()+height()-ny)/2 -3 );

	zoomPoints[4]->move( nx -3, y() +height() -3 );
	zoomPoints[5]->move( x() +(nx-x())/2 -3, y() +height() -3 );

	//[6] is fix point

	zoomPoints[7]->move( x() -3, ny +( y()+height()-ny)/2 -3 );

	zoomPoints[activeZP]->setActive(false);

	activeZP = 2;
	zoomPoints[2]->setActive(true);

} //moveP3(...)


void widgetHolder::moveP4( int nx, int ny ) //SLOT
{
bool otherMove = false;

	if ( nx < x() +5 )
	{
		otherMove = true;
		nx = x() +5;
	}


	if ( ny != y() +height()/2 )
	{
		otherMove = true;
		ny = y() +height()/2;
	}

	if ( otherMove )
		zoomPoints[3]->move( nx-3, ny-3 );


	//[0] is fix point
	zoomPoints[1]->move( x() +(nx-x())/2 -3, y() -3 );
	zoomPoints[2]->move( nx -3, y() -3 );

	zoomPoints[4]->move( nx -3, y()+height() -3 );
	zoomPoints[5]->move( x() +(nx-x())/2 -3, y() +height() -3 );

	//[6]-[7] are fix points

	zoomPoints[activeZP]->setActive(false);

	activeZP = 3;
	zoomPoints[3]->setActive(true);

} //moveP4(...)


void widgetHolder::moveP5( int nx, int ny ) //SLOT
{
bool otherMove = false;

	if ( nx < x() +5 )
	{
		otherMove = true;
		nx = x() +5;
	}


	if ( ny < y() +5 )
	{
		otherMove = true;
		ny = y() +5;
	}

	if ( otherMove )
		zoomPoints[4]->move( nx-3, ny-3 );

	//[0] is fix point
	zoomPoints[1]->move( x() +(nx-x())/2 -3, y() -3 );
	zoomPoints[2]->move( nx -3, y() -3 );

	zoomPoints[3]->move( nx -3, y() +(ny-y())/2 -3 );

	zoomPoints[5]->move( x() +(nx-x())/2 -3, ny -3 );
	zoomPoints[6]->move( x() -3, ny -3 );

	zoomPoints[7]->move( x() -3, y() +(ny-y())/2 -3 );

	zoomPoints[activeZP]->setActive(false);

	activeZP = 4;
	zoomPoints[4]->setActive(true);

} //moveP5(...)


void widgetHolder::moveP6( int nx, int ny ) //SLOT
{
bool otherMove = false;

	if ( nx != x() +(width()/2) )
	{
		otherMove = true;
		nx = x() +width()/2;
	}


	if ( ny < y() +5 )
	{
		otherMove = true;
		ny = y() +5;
	}

	if ( otherMove )
		zoomPoints[5]->move( nx-3, ny-3 );


	//[0]-[2] are fix points
	zoomPoints[3]->move( x()+width()-3, y() +(ny-y())/2 -3 );

	zoomPoints[4]->move( x() +width() -3, ny -3 );

	zoomPoints[6]->move( x() -3, ny -3 );

	zoomPoints[7]->move( x() -3, y() +(ny-y())/2 -3 );

	zoomPoints[activeZP]->setActive(false);

	activeZP = 5;
	zoomPoints[5]->setActive(true);
	
} //moveP6(...)


void widgetHolder::moveP7( int nx, int ny ) //SLOT
{
bool otherMove = false;

	if ( nx > x() +width() -5 )
	{
		otherMove = true;
		nx = x() +width() -5;
	}


	if ( ny < y() +5 )
	{
		otherMove = true;
		ny = y() +5;
	}

	if ( otherMove )
		zoomPoints[6]->move( nx-3, ny-3 );


	zoomPoints[0]->move( nx -3, y() -3 );
	zoomPoints[1]->move( nx +(x()+width()-nx)/2 -3, y() -3 );

	//[2] is fix point

	zoomPoints[3]->move( x()+width()-3, y() +(ny-y())/2 -3 );

	zoomPoints[4]->move( x() +width() -3, ny -3 );
	zoomPoints[5]->move( nx +(x()+width()-nx)/2 -3, ny -3 );

	zoomPoints[7]->move( nx -3, y() +(ny-y())/2 -3 );

	zoomPoints[activeZP]->setActive(false);

	activeZP = 6;
	zoomPoints[6]->setActive(true);

} //moveP7(...)


void widgetHolder::moveP8( int nx, int ny ) //SLOT
{
bool otherMove = false;

	if ( nx > x() +width() -5 )
	{
		otherMove = true;
		nx = x() +width() -5;
	}


	if ( ny != y() +height()/2 )
	{
		otherMove = true;
		ny = y() +height()/2;
	}

	if ( otherMove )
		zoomPoints[7]->move( nx-3, ny-3 );


	zoomPoints[0]->move( nx -3, y() -3 );
	zoomPoints[1]->move( nx +(x()+width()-nx)/2 -3, y() -3 );

	//[2]-[4] are fix points

	zoomPoints[5]->move( nx +(x()+width()-nx)/2 -3, y() +height() -3 );
	zoomPoints[6]->move( nx -3, y()+height() -3 );


	zoomPoints[activeZP]->setActive(false);

	activeZP = 7;
	zoomPoints[7]->setActive(true);

} //moveP8(...)


void widgetHolder::moveOK() //SLOT
{
int newX, newY, newW, newH;

	newX = zoomPoints[0]->x()+3;
	newY = zoomPoints[0]->y()+3;

	newW = zoomPoints[2]->x() - zoomPoints[0]->x();
	newH = zoomPoints[4]->y() - zoomPoints[2]->y();

	setGeometry( newX, newY, newW, newH );

	resetZPs();
}


void widgetHolder::moveCancel() //SLOT
{
	resetZPs();
}
