/*************************************************************
*
* (c) 1999 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/


#include "topwin.h"
#include "topwin.moc"

/******************************************************************************
	class titleBar:
*******************************************************************************/

titleBar::titleBar( QWidget *parent, QWidget *ncW ) : QWidget(parent)
{
	newTitle = new eQLineEdit(this);
	newTitle->hide();

	title = "";
	cW = ncW;

	mX = 0;
	mY = 0;

	moveMode = false;

	lower();

	connect( newTitle, SIGNAL( focusOut() ), SLOT( cancelChange() ) );
	connect( newTitle, SIGNAL( returnPressed() ), SLOT( acceptChange() ) );
}


void titleBar::setText( QString newText )
{
	title = newText;

	drawWidget();
}


void titleBar::drawWidget()
{
QPainter p;

	p.begin(this);

	p.setPen( QColor( 100, 100, 100 ) );
	p.setBrush( QColor( 0, 0, 120 ) );

	p.drawRect( 0, 0, width(), height() );

	p.setPen( white );

	p.drawText( rect(), AlignCenter, title );

	p.end();
}


void titleBar::paintEvent( QPaintEvent * )
{
	drawWidget();
}


void titleBar::mousePressEvent( QMouseEvent *e )
{
	if ( e->button() == LeftButton )
	{

		cW->setFocus();

		mX = x() - e->globalX();
		mY = y() - e->globalY();

		moveMode = true;

	}

}


void titleBar::mouseReleaseEvent( QMouseEvent * )
{
	moveMode = false;
	lower();
}


void titleBar::mouseMoveEvent( QMouseEvent *e )
{
	if ( moveMode )
	{
		move( e->globalX() +mX, e->globalY() +mY );
		cW->move( e->globalX() + mX, e->globalY() +mY +height() );
	}
}


void titleBar::resizeEvent( QResizeEvent * )
{
	newTitle->setGeometry( 0, 0, width(), height() );
}


void titleBar::mouseDoubleClickEvent( QMouseEvent * )
{
	newTitle->setText(title);
	newTitle->show();
	newTitle->setFocus();
}


void titleBar::cancelChange() //SLOT
{
	newTitle->hide();
}


void titleBar::acceptChange() //SLOT
{
	newTitle->hide();

	setText( newTitle->text() );

	emit textChanged( title );
}



/******************************************************************************
	class topWin:
*******************************************************************************/

topWin::topWin( QWidget *parent ) : widgetHolder( parent )
{
QString nps[11], nvs[11];
QString hStr;

	r = backgroundColor().red();
	g = backgroundColor().green();
	b = backgroundColor().blue();

	nps[0] = "Name"; nvs[0] = "Window";
	nps[1] = "Caption"; nvs[1] = "New Window";

	nps[2] = "Width"; nvs[2] = hStr.setNum( width() );
	nps[3] = "Height"; nvs[3] = hStr.setNum( height() );

	nps[4] = "MinimalWidth"; nvs[4] = "5";
	nps[5] = "MinimalHeight"; nvs[5] = "5";

	nps[6] = "MaximalWidth"; nvs[6] = "(none)";
	nps[7] = "MaximalHeight"; nvs[7] = "(none)";

	nps[8] = "Visible"; nvs[8] = "TRUE";

	nps[9] = "BackgroundColor";
	nvs[9] = QString( "(" +hStr.setNum(r) +"," +hStr.setNum(g) +","
		+hStr.setNum(b) +")" );

	nps[10] = "";

	haveXY = false;

	buildProperties( nps, nvs );

	pix.resize( width(), height() );
	pix.fill( QColor( r, g, b ) );

	setImage(pix);

	allowSubs = true;

	tBar = new titleBar(parent,this);
	tBar->show();

	ownType = ID_WIN;

	connect( tBar, SIGNAL( textChanged(QString) ), SLOT( tbTitle(QString) ) );


}


void topWin::move( int xP, int yP )
{
	setGeometry( xP, yP, width(), height() );
	
}


void topWin::destroyBars()
{
	delete tBar;
}


void topWin::drawPix()
{
QPainter p;

	pix.resize( width(), height() );
	pix.fill( QColor( r, g, b ) );

	p.begin(&pix);

	p.setPen(black);
	p.drawRect( 0, 0, width(), height() );

	p.end();

	setImage(pix);
}

void topWin::positionTitle()
{
	tBar->setGeometry( x(), y()-20, width(), 20 );
}

void topWin::changeTitle( QString newTitle )
{
	tBar->setText( newTitle );
	positionTitle();
}


void topWin::newProperties( QString props[], QString vals[] )
{
bool ok;
QString hStr;
int i;
int inti1, inti2;
int w = 5, h = 5;

	for ( i = 0; props[i] != ""; i++ )
	{
		if( props[i] == "Name" )
		{
			//Nothing to do
		}
		else if( props[i] == "Caption" )
		{
			changeTitle( vals[i] );
		}
		else if( props[i] == "Width" )
		{
			w = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			if ( w != width() ) resize( w, height() );

			positionTitle();

		}
		else if( props[i] == "Height" )
		{
			h = vals[i].toInt( &ok );

			if (!ok)
				fatal ( "Illegal value (non-integer)." );

			if ( h != height() ) resize( width(), h );

			positionTitle();

		}
		else if( props[i] == "MinimalWidth" )
		{
		}
		else if( props[i] == "MinimalHeight" )
		{
		}
		else if( props[i] == "MaximalWidth" )
		{
		}
		else if( props[i] == "MaximalHeight" )
		{
		}
		else if( props[i] == "Visible" )
		{
		}
		else if( props[i] == "BackgroundColor" )
		{
			inti1 = 1; inti2 = 0;

			while( isdigit(vals[i][inti1]) )
			{
				hStr.resize( inti2 +2 );

				hStr[inti2] = vals[i][inti1];
				inti1++; inti2++;
			}

			r = hStr.toInt();

			inti1++; inti2 = 0;

			while( isdigit(vals[i][inti1]) )
			{
				hStr.resize( inti2 +2 );

				hStr[inti2] = vals[i][inti1];
				inti1++; inti2++;
			}

			g = hStr.toInt();

			inti1++; inti2 = 0;

			while( isdigit(vals[i][inti1]) )
			{
				hStr.resize( inti2 +2 );

				hStr[inti2] = vals[i][inti1];
				inti1++; inti2++;
			}

			b = hStr.toInt();

		}
		else
			fatal ( "In topWin::newProperties(...): Illegal property (Internal error)." );

	} //for

	drawPix();

} //newProperties(...)


void topWin::tbTitle( QString nt )
{
	changeProperty( "Caption", nt );
}