/*************************************************************
*
* (c) 1999 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "scan.h"
#include "errorx.h"

#define bool int
#define true 1
#define false 0

FILE *scanFile;

char *ProjectConf = 0L, *VKTF = 0L, *VKC = 0L, *rmwid = 0L;
char *f_name = 0L;
char *filecont = 0L;
char *mytype, *mywname;

int activeLine;
int pconfA, pconfB;

struct inf_block
{
	char *name;
	char *value;

	struct inf_block *next;
};

struct inf_block *vars = 0L;
struct inf_block *consts = 0L;
struct inf_block *funcs = 0L;
struct inf_block *rwidgets = 0L;
struct inf_block *gwidgets = 0L;

enum list_entries
{
	wtype, myname,
	var_name, var_val,
	const_name, const_val,
	func_name, func_args,
	robj_type, robj_name,
	obj_type, obj_name,
	nothing
};


void readFile()
{
int i;
char c;

	free(filecont);
	filecont=malloc(sizeof(char));
	filecont[0] = 0L;

	i = 0;

	while( (c=fgetc(scanFile)) != EOF )
	{
		if ( ( filecont=realloc(filecont,(i+2)*sizeof(char)) ) == 0L )
		{
			printf( "vkConfigMaker: Can't allocate memory.\n" );
			abort();
		}

		filecont[i] = c;
		filecont[i+1] = 0L;


		i++;
	}

}

bool anyName( int check )
{
	if ( check == NAME || check == TYPE || check == WINDOW )
		return true;
	else
		return false;
}

void dstrcp( char **dst, char *src )
{
int i;
char *dest = *dst;

	dest=malloc(sizeof(char));

	dest[0] = 0L;

	for( i = 0; src[i] != 0; i++ )
	{
		dest = realloc( dest, i+2*sizeof(char) );
		dest[i] = src[i];
	}

	dest[i] = 0L;

	*dst = dest;

}

void take( enum list_entries etype )
{
char *entr;
struct inf_block *newvar;
struct inf_block *newconst;
struct inf_block *newfunc;
struct inf_block *newobj;
int i;


	switch( etype )
	{
		case wtype:
			entr = pop();
			dstrcp( &mytype, entr );
			free(entr);
			break;

		case myname:
			entr = pop();
			free(entr);

			/* mywname allready avaible; but I must make a widget name
				from the file name: */

			i = strlen(mywname)-1;
			while(mywname[i] != '.')
				i--;

			mywname[i] = 0L;

			while(mywname[i] != '/')
			{
				i--;
				if( i == -1 ) break;
			}

			mywname = mywname + (i+1)*sizeof(char);

			break;

		case var_name:
			entr = pop();

			newvar = (struct inf_block *) malloc( sizeof(struct inf_block) );
			newvar->next = vars;
			vars = newvar;
			dstrcp(&newvar->name, entr );

			free(entr);
			break;

		case var_val:
			entr = pop();
			dstrcp(&vars->value, entr );
			free(entr);
			break;

		case const_name:
			entr = pop();

			newconst = (struct inf_block *) malloc( sizeof(struct inf_block) );
			newconst->next = consts;
			consts = newconst;
			dstrcp(&newconst->name, entr );

			free(entr);
			break;

		case const_val:
			entr = pop();
			dstrcp(&consts->value, entr );
			free(entr);
			break;

		case func_name:
			entr = pop();

			newfunc = (struct inf_block *) malloc( sizeof(struct inf_block) );
			newfunc->next = funcs;
			funcs = newfunc;
			dstrcp(&newfunc->name, entr );

			free(entr);
			break;

		case func_args:
			entr = pop();
			dstrcp(&funcs->value, entr );
			free(entr);
			break;

		case robj_type:
			entr = pop();

			newobj = (struct inf_block *) malloc( sizeof(struct inf_block) );
			newobj->next = rwidgets;
			rwidgets = newobj;
			dstrcp(&newobj->value, entr );

			free(entr);
			break;

		case robj_name:
			entr = pop();
			dstrcp(&rwidgets->name, entr );
			free(entr);
			break;

		case obj_type:
			entr = pop();

			newobj = (struct inf_block *) malloc( sizeof(struct inf_block) );
			newobj->next = gwidgets;
			gwidgets = newobj;
			dstrcp(&newobj->value, entr );

			free(entr);
			break;

		case obj_name:
			entr = pop();
			dstrcp(&gwidgets->name, entr );
			free(entr);
			break;

		default: /* nothing */
			free( pop() );
			break;

	} /* switch */

}

void parseVKTF()
{
int r;
	f_name = VKTF;

	start( filecont );

	if( next() != WINDOW ) /* Window */
		errorx(1);

	take(wtype); /* Save "Window" or "SubWindow" */

	if( !anyName(next()) ) /* Window name */
		errorx(2);

	take(myname);

	if( next() != PARA ) /* ( */
		errorx(3);

	take(nothing);

	if( next() != PROPS ) /* Properties */
		errorx(4);

	take(nothing);

	if( next() != PARA ) /* ( */
		errorx(3);

	take(nothing);

	r = NAME;

	while( r != PARB ) /* Property settings */
	{
		r = next();

		take(nothing);

		if( r != PARB )
		{
			if( !anyName(r) )
				errorx(2);

			if( next() != SET )
				errorx(5);

			if( next() != VALUE )
				errorx(6);


			if( next() != SCOL )
			{
				errorx(6);
			}

			take(nothing); take(nothing); take(nothing);

		}


	} /* while */


	if( next() != VARS ) /* Regional */
		errorx(7);

	take(nothing);

	if( next() != PARA ) /* ( */
		errorx(3);

	take(nothing);

	r = NAME;

	while( r != PARB ) /* Variable declarations */
	{
		r = next();


		if( r != PARB )
		{
			if( !anyName(r) )
				errorx(2);

			take(var_name);

			if( next() != SET )
				errorx(5);

			take(nothing);

			r = next();

			if( r != VALUE )
				errorx(6);

			take(var_val);
			
			if( next() != SCOL )
				errorx(6);

			take(nothing);
		}


	} /* while */


	if( next() != CONSTS ) /* RegConst */
		errorx(8);

	take(nothing);

	if( next() != PARA ) /* ( */
		errorx(3);

	take(nothing);

	r = NAME;

	while( r != PARB ) /* Constant declarations */
	{
		r = next();


		if( r != PARB )
		{
			if( !anyName(r) )
				errorx(2);

			take(const_name);

			if( next() != SET )
				errorx(5);

			take(nothing);

			r = next();

			if( r != VALUE )
				errorx(6);

			take(const_val);
			
			if( next() != SCOL )
				errorx(6);

			take(nothing);

		} else take(nothing);

	} /* while */


	if( next() != FUNCS ) /* Functions */
		errorx(9);

	take(nothing);

	if( next() != PARA ) /* ( */
		errorx(3);

	take(nothing);

	r = NAME;

	while( r != PARB ) /* Function declarations */
	{
		r = next();


		if( r != PARB )
		{
			if( !anyName(r) )
				errorx(2);

			take(func_name);

			if( next() != DBLP )
				errorx(10);

			take(nothing);

			r = next();

			if( r != ARGNUM )
				errorx(11);

			take(func_args);
			
			if( next() != SCOL )
				errorx(6);

			take(nothing);
		}
		else take(nothing);

	} /* while */


	if( next() != OBJECTS ) /* SubWidgets */
		errorx(12);

	take(nothing);

	if( next() != PARA ) /* ( */
		errorx(3);

	take(nothing);

	r = NAME;

	while( r != PARB ) /* Sub widgets */
	{
		r = next();

		if( r != PARB )
		{
			if( r != TYPE && r != WINDOW )
				errorx(13);

			take(robj_type);

			if( !anyName(next()) )
				errorx(2);

			take(robj_name);

			if( next() != PARA ) /* '(' */
				errorx(3);

			take(nothing);

			/* Parse sub widgets properties: */

			r = NAME;

			while( r != PARB ) /* Widget's property settings */
			{
				r = next();

				take(nothing);

				if( r != PARB )
				{
					if( !anyName(r) )
						errorx(2);

					if( next() != SET )
						errorx(5);



					if( next() != VALUE )
						errorx(6);


					if( next() != SCOL )
					{
						errorx(6);
					}

					take(nothing); take(nothing); take(nothing);
				}

			} /* while (sub widgets)*/

			r = NAME;

		}
		else take(nothing);

	} /* while */

	/* Closing vk(t)f file: */

	if( next() != PARB ) /* ')' */
		errorx(14);

} /* parseVKTF() */


void parsePConf()
{
int r, section;

	f_name = ProjectConf;

	start( filecont );

	if( next() != PROJECT ) /* Project */
		errorx(15);

	take(nothing);

	if( next() != PARA ) /* ( */
		errorx(3);

	take(nothing);

	r = NAME;

	while( r != PARB ) /* Config settings */
	{
		r = next();

		take(nothing);

		if( r != PARB )
		{
			if( !anyName(r) )
				errorx(2);

			if( next() != SET )
				errorx(5);



			if( next() != VALUE )
				errorx(6);


			if( next() != SCOL )
			{
				errorx(6);
			}

			take(nothing); take(nothing); take(nothing);
		}


	} /* while */

	if( next() != GLOBALS ) /* Globals */
		errorx(16);

	take(nothing);

	if( next() != PARA ) /* ( */
		errorx(3);

	take(nothing);

	r = NAME;

	while( r != PARB ) /* End of "Globals" section */
	{

		r = next();

		if( r != PARB )
		{
			if( r != VARS && r != CONSTS && r != FUNCS )
				errorx(17);

			section = r;

			take(nothing);

			if( next() != PARA ) /* '(' */
				errorx(3);

			take(nothing);

			/* Parse variables, contants or functions: */

			r = NAME;

			while( r != PARB ) /* Variables, Consts or Functions */
			{
				r = next();

				if( r != PARB )
				{
					if( !anyName(r) )
						errorx(2);

					switch(section)
					{
						case VARS: take(var_name);
							break;

						case CONSTS: take(const_name);
							break;

						case FUNCS: take(func_name);
							break;
					}

					if( section == FUNCS )
					{
						if( next() != DBLP )
							errorx(10);
					}
					else
					{
						if( next() != SET )
							errorx(5);
					}

					take(nothing);

					switch(section)
					{

						case VARS: if( next() != VALUE )
								errorx(6);
							take(var_val);
							break;

						case CONSTS: if( next() != VALUE )
								errorx(6);
							take(const_val);
							break;

						case FUNCS: if( next() != ARGNUM )
								errorx(11);
							take(func_args);
							break;
					}

					if( next() != SCOL )
					{
						errorx(6);
					}

					take(nothing);
				}
				else take(nothing);

			} /* while (sub block)*/

			r = NAME;

		}
		else take(nothing);

	} /* while */


	if( next() != OBJECTS ) /* Widgets */
		errorx(18);

	take(nothing);

	if( next() != PARA ) /* ( */
		errorx(3);

	take(nothing);

	r = NAME;

	pconfA = actualPos();

	while( r != PARB ) /* Widget declarations */
	{
		r = next();


		if( r != PARB )
		{
			if( r != TYPE && r != WINDOW )
				errorx(13);

			take(obj_type);

			if( !anyName(next()) )
				errorx(2);

			take(obj_name);

			if( next() != SCOL )
				errorx(6);

			take(nothing);
		}
		else take(nothing);

	} /* while */

	pconfB = actualPos() -1;

	if( next() != EOFI )
		errorx(19);

} /* parsePConf() */

bool XFile( char *x, char *check )
{
int i = strlen(check)-1, ii = strlen(x) -1;

	while( ii > 0 )
	{
		if( check[i] != x[ii] )
			return false;

		i--;
		ii--;

		if( i == 0 )
			return false;
	}

	if ( check[i-1] == '.' )
		return true;
	else
		return false;


}

void putLower( char *str, FILE *f )
{
int i;

	for( i = 0; str[i] != 0L; i++ )
		fputc( tolower(str[i]), f );
}


void remakePConf( char *fn )
{
FILE *pConf;
char *aname;
int p1, p2;
int i, ii = 0;
struct inf_block *tmpwid, *previous, *nentr;

	/* Merge regional and global widget lists together: */

	/* 1) Get complete name of active (Sub-)window: */
	if( strcmp( mytype, "SubWindow" ) == 0 )
	{
		for( p1 = strlen(VKTF) -1; p1 > 0; p1-- )
		{
			if( VKTF[p1] == '/' )
			{
				p1++;
				break;
			}
		}

		p2 = strlen(VKTF) -1;
		while( VKTF[p2] != '.' )
			p2--;

		aname = (char *) malloc( sizeof(char) * (p2-p1+1) );

		for( i = p1; i < p2; i++ )
		{
			aname[ii] = VKTF[i];

			if( aname[ii] == '_' ) aname[ii] = '.';

			ii++;
		}

		aname[ii] = 0L;

	}
	else /* just take the widget name */
		aname = mywname;


	/* 2) Remove everything from gwidgets that belongs to this (sub)window: */

	previous = gwidgets;

	for( tmpwid = gwidgets; tmpwid != 0L; tmpwid = tmpwid->next )
	{


		if( strncmp( tmpwid->name, aname, strlen(aname) ) == 0 )
		{

			if( previous == gwidgets )
			{
				gwidgets = tmpwid->next;
				previous = gwidgets;
			}
			else
				previous->next = tmpwid->next;
		}
		else
			previous = tmpwid;

	}

	/* 3) Make regionals "absolute": */

	for( tmpwid = rwidgets; tmpwid != 0L; tmpwid = tmpwid->next )
	{
		tmpwid->name = realloc( tmpwid->name, strlen(tmpwid->name)
			+strlen(aname) +2 );

		for( i = strlen(tmpwid->name); i >= 0; i-- )
			tmpwid->name[i+strlen(aname)+1] = tmpwid->name[i];

		for( i = 0; i < strlen(aname); i++ )
			tmpwid->name[i] = aname[i];

		tmpwid->name[i] = '.';

	}

	/* 4) Add absolute name of THIS (only if NOT SubWindow): */

	if( strcmp( mytype, "SubWindow" ) != 0 )
	{
		tmpwid = (struct inf_block *) malloc( sizeof(struct inf_block) );
		tmpwid->name = malloc( strlen(aname) );
		tmpwid->name[0] = 0L;
		strcat( tmpwid->name, aname );
		tmpwid->value = malloc( strlen(mytype) );
		tmpwid->value[0] = 0L;
		strcat( tmpwid->value, mytype );
		tmpwid->next = rwidgets;
		rwidgets = tmpwid;
	}

	/* 5) Finally link them together (to gwidgets): */

	for( tmpwid = rwidgets; tmpwid != 0L; tmpwid = tmpwid->next )
	{
		nentr = (struct inf_block *) malloc( sizeof( struct inf_block ) );
		nentr->name = tmpwid->name;
		nentr->value = tmpwid->value;

		nentr->next = gwidgets;
		gwidgets = nentr;
	}

	/* Now, save information: */
	pConf = fopen( fn, "w" );

	/* 1) Stuff before "Widgets" section: */
	for( i = 0; i <= pconfA; i++ )
		fputc( filecont[i], pConf );

	/* 2) Widget information: */
	for( tmpwid = gwidgets; tmpwid != 0L; tmpwid = tmpwid->next )
	{
		fputc( '\t', pConf );
		fputs( tmpwid->value, pConf );
		fputc( ' ', pConf );
		fputs( tmpwid->name, pConf );
		fputs( ";\n", pConf );
	}

	/* 3) Stuff after "Widgets" section: */
	for( i = pconfB; filecont[i] != 0L; i++ )
		fputc( filecont[i], pConf );

	fclose(pConf);

} /* remakePConf(...) */

void makeVKC( char *fn )
{
struct inf_block *donow;
FILE *vkc_file;

	vkc_file = fopen( fn, "w" );

	printf( "Generating *.vkc output ...\n" );

	putLower( mywname, vkc_file );
	fputs( "\n#\n", vkc_file );

	for( donow = consts; donow != 0L; donow = donow->next )
	{
		putLower(donow->name, vkc_file);
		fputc(' ', vkc_file);
		putLower(donow->value, vkc_file);
		fputc('\n', vkc_file);
	}

	fputs( "#\n", vkc_file );

	for( donow = vars; donow != 0L; donow = donow->next )
	{
		putLower(donow->name, vkc_file);
		fputc(' ', vkc_file);
		putLower(donow->value, vkc_file);
		fputc('\n', vkc_file);
	}

	fputs( "#\n", vkc_file );

	for( donow = funcs; donow != 0L; donow = donow->next )
	{
		putLower(donow->name, vkc_file);
		fputc(' ', vkc_file);

		switch( strlen(donow->value) )
		{
			case 1: fputc('0', vkc_file);
				putLower(donow->value, vkc_file);
				fputc('\n', vkc_file);
				break;

			case 2: putLower(donow->value, vkc_file);
				fputc('\n', vkc_file);
				break;

			default:
				printf( "vkConfigmaker: Argument number string is longer than two digits.\n" );
				exit(3);
				break;
		}
	}

	fputs( "#\n", vkc_file );

	if( strcmp( mytype, "MainWindow" ) == 0 )
		fputs( "MAIN\n#\n", vkc_file );
	if( strcmp( mytype, "Window" ) == 0 )
		fputs( "WIN\n#\n", vkc_file );
	else if( strcmp( mytype, "SubWindow" ) == 0 )
		fputs( "SUB\n#\n", vkc_file );

	for( donow = gwidgets; donow != 0L; donow = donow->next )
	{
		putLower(donow->value, vkc_file);
		fputc(' ', vkc_file);
		putLower(donow->name, vkc_file);
		fputc('\n', vkc_file);
	}

	fputs( "#\n", vkc_file );
	fputs( "\nGenerated by vkConfigmaker\n", vkc_file );

	fclose(vkc_file);

} /* makeVKC(...) */


void rmwidget( char *fn )
{
FILE *pConf;
char wn[512] = "";
struct inf_block *tmpwid, *previous;
int i, ii = 0;

	/* 1/4) Get widget name: */
	strcat( wn, rmwid +5*sizeof(char) );

	/* 2/4) Regular parsing: */
	parsePConf();

	/* 3/4) Remove all of rmwids sub widgets: */
	previous = gwidgets;

	for( tmpwid = gwidgets; tmpwid != 0L; tmpwid = tmpwid->next )
	{

		if( strncmp( tmpwid->name, wn, strlen(wn) ) == 0 )
		{
			ii++;

			if( previous == gwidgets )
			{
				gwidgets = tmpwid->next;
				previous = gwidgets;
			}
			else
				previous->next = tmpwid->next;

		}
		else
			previous = tmpwid;

	}

	/* 4/4) Save new project.conf: */
	pConf = fopen( fn, "w" );

	for( i = 0; i <= pconfA; i++ )
		fputc( filecont[i], pConf );

	for( tmpwid = gwidgets; tmpwid != 0L; tmpwid = tmpwid->next )
	{

		fputc( '\t', pConf );
		fputs( tmpwid->value, pConf );
		fputc( ' ', pConf );
		fputs( tmpwid->name, pConf );
		fputs( ";\n", pConf );
	}

	for( i = pconfB; filecont[i] != 0L; i++ )
		fputc( filecont[i], pConf );

	fclose(pConf);

	printf( "%d entries removed.\n" );

} /* rmwidget() */


/* main: */
main( int argc, char **argv )
{


	while( argc > 1 )
	{
		argc--;


		if( XFile( "conf", argv[argc] ) )
			ProjectConf = argv[argc];
		else if( XFile( "vktf", argv[argc] ) || XFile( "vkf", argv[argc] ) )
			VKTF = argv[argc];
		else if( XFile( "vkc", argv[argc] ) )
			VKC = argv[argc];
		else if( strncmp( argv[argc], "--rm:", 5 ) == 0 )
			rmwid = argv[argc];
		else
		{
			printf( "vkConfigmaker: Invalid argument.\n" );
			printf( "Usage: vkConfigmaker project.conf *.vk(t)f [*.vkc]\n" );
			printf( "Or: vkConfigmaker project.conf --rm:widget_name\n" );
			exit(1);
		}

	}

	if( ProjectConf == 0L )
	{
		printf( "vkConfigmaker: Can't work without project.conf.\n" );
		exit(1);
	}

	if( rmwid != 0L ) /* Remove widget entries instead of VKC generation */
	{
		if( VKTF != 0L || VKC != 0L )
		{
			printf( "vkConfigmaker: Can't process *.vkc generation / project.conf " );
			printf( "update and rm-command at one time.\n" );
		}

		scanFile = fopen( ProjectConf, "r" );
		readFile();
		fclose(scanFile);

		rmwidget(ProjectConf);
		exit(0);
	}

	if( VKTF != 0L )
	{
		scanFile = fopen( VKTF, "r" );
		readFile();
		fclose(scanFile);

		dstrcp( &mywname, VKTF );

		parseVKTF();
	}
	else
	{
		printf( "vkConfigmaker: I need a *.vk(t)f to update project.conf.\n" );
		exit(1);
	}

	scanFile = fopen( ProjectConf, "r" );
	readFile();
	fclose(scanFile);

	parsePConf();

	remakePConf( ProjectConf );

	if( VKC != 0L )
	{
		makeVKC(VKC);
	}

} /* main */
