/***************************************************************************
                          value.h  -  description                              
                             -------------------                                         
    begin                : Thu Mar 18 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef VALUE_H
#define VALUE_H

#include <qwidget.h>
#include "valueeditor.h"

/**
	* This class represents a value such as a string or int.
	*
  * @author Richard Moore
  */
class Value
{
public:
	/**
		* Create a Value
		*/
	Value();
	virtual ~Value();

	/**
		* Instantiate an edit view for the correct type with the widget
		* specified as the parent.
		*/
	virtual ValueEditor *createEditor(QWidget *);

	/**
		* Can you get a pixmap view of the value.
		*/
	virtual bool hasPixmapView();

	/**
		* Get the pixmap representation of the value. This will be 0 if
		* it cannot be represented in this way.
		*/
	virtual QPixmap *toPixmap(int width= 15, int height= 15);

	/**
		* Convert the value to a string.
		*/
	virtual const char *toString();

	/**
		* Set the value from a string.
		*/
	virtual void fromString(const char *);
};

#endif





