#include <qdir.h>
#include <dlfcn.h>
#include <kapp.h>
#include "componentmanager.h"
#include "package.h"
#include "pluginloader.h"

// Define this only on platforms that support the dlXXX functions
#define ENABLE_PLUGINS

// Glob used to identify plugins
static const char *PLUGIN_FILE_GLOB= "*.kgp";

// Package *init_kgui_plugin()
static const char *INIT_HOOK_NAME= "init_kgui_plugin";

static const char *SYSTEM_DIR_KEY= "SystemPluginDir";
static const char *USER_DIR_KEY= "UserPluginDir";
static const char *DEFAULT_SYSTEM_DIR= "/opt/kde/lib/kgui";
static const char *DEFAULT_USER_DIR= ".kde/lib/kgui";

void PluginLoader::install(ComponentManager *cm)
{
  KConfig *config= kapp->getConfig();

  KConfigGroupSaver saver(config, "Plugins");

	QString system;
	QString user;

	system= config->readEntry(SYSTEM_DIR_KEY, DEFAULT_SYSTEM_DIR);
	user= config->readEntry(USER_DIR_KEY, DEFAULT_USER_DIR);
		
	QString path= QDir::homeDirPath();
	path.append("/");
	path.append(user);
	
	warning("Installing plugins from %s and %s", path.data(), system.data());
	installDir(cm, system);
	installDir(cm, path);
}

void PluginLoader::installDir(ComponentManager *cm, const char *dirname)
{
	QDir dir(dirname, PLUGIN_FILE_GLOB);
	
  if (dir.isReadable()) {
		const QFileInfoList *entries= dir.entryInfoList(QDir::Files | QDir::Readable);

		QFileInfoListIterator it(*entries);
		while (QFileInfo *info= it.current()) {		
			if (!installPlugin(cm, info->absFilePath())) {
				warning("Could not load plugin %s", info->absFilePath().data());
			}
			++it;
		}
	}
}


bool PluginLoader::installPlugin(ComponentManager *cm, const char *path)
{
	bool result= false;

#ifdef ENABLE_PLUGINS
	typedef Package* (*initHook)(void);
  Package *pkg;

  void *handle= dlopen(path, RTLD_NOW);

  if (handle) {
  	// Call the init hook
    initHook hook= (initHook) dlsym( handle, INIT_HOOK_NAME );
    if (hook) {
	  	pkg= (*hook)();

	    if (pkg) {
	    	warning("Plugin %s loaded", pkg->name());
	      cm->addPackage(pkg);
	      result= true;
	    }
	    else {
  	     warning("Plugin init function failed");
	    }
	  }
	  else {
			warning("Could not resolve init function %s", dlerror());
	  }
  }
  else {
     warning("Could not load library, %s", dlerror());
  }

#endif // ENABLE_PLUGINS

   return result;
}








