/***************************************************************************
                          kguiview.h  -  description                              
                             -------------------                                         
    begin                : Mon Mar 15 23:42:04 GMT 1999
                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KGUIVIEW_H 
#define KGUIVIEW_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <kapp.h>
#include <qwidget.h>
#include <qscrollview.h>
#include "kguidoc.h"
#include "hierarchyview.h"

class PropertyDialog;

/**
 * This class provides an incomplete base for your application view.
 */
class KGUIView : public QWidget
{
  Q_OBJECT

 public:
  /** Constructor for the main view */
  KGUIView(KApplication* a=0,KGUIDoc* doc=0,QWidget *parent = 0);
  /** Destructor for the main view */
  ~KGUIView();

  KGUIDoc *document();

 public slots:
	void select(Instance *);
	void select(QListViewItem *);
	void showProperties(Instance *);
	void properties(QListViewItem *);

signals:
	void selectionChanged(Instance *);
	void selectionChanged(QListViewItem *);
	void activate(Instance *);

 private:
	HierarchyView *hierarchyView;
	QScrollView *scroller;
	Instance *selectedInstance;
	PropertyDialog *propDlg;
	KGUIDoc *document_;
};

#endif // KGUIVIEW_H 




















