/***************************************************************************
                          hierarchyview.h  -  description                              
                             -------------------                                         
    begin                : Mon Mar 15 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef HIERARCHY_VIEW_H
#define HIERARCHY_VIEW_H

#include <qwidget.h>
#include <qlistview.h>
#include <qptrdict.h>
#include "instance.h"

class KGUIDoc;

/**
 * Displays the widget hierarchy to the user. The tree will also include
 * organisational nodes that are not widget instances.
 */
class HierarchyView : public QListView
{
	Q_OBJECT

public:
	HierarchyView(QWidget *parent, const char *name= 0);
	~HierarchyView();

	/**
		* Set the document whose hierarchy will be shown (this sets the root instance
		* automatically.
		*/
	void setDocument(KGUIDoc *);
	
	/**
	 * Set the root of the displayed tree.
	 */
	void setRoot(Instance *root);

	/**
		* Map a list item to the underlying instance.
		*/
	Instance *findInstance(QListViewItem *);

	/**
		* Delete the specified instance.
		*/
	void deleteInstance(Instance *);
	
public slots:
	void showPopup(QListViewItem *, const QPoint &);
	
	/**
	 * Refresh the view.
   */
	void refresh();

	/**
		* Refresh the subset of the view below the specified Instance.
   	*/
	void refresh(Instance *);

		
signals:
	void selectionChanged();
	void selectionChanged(QListViewItem *);
	void rightButtonPressed( QListViewItem *, const QPoint&, int );
	void rightButtonClicked( QListViewItem *, const QPoint&, int );
	void showProperties( Instance * );
	
protected:
	/**
		* The document being viewed.
		*/
	KGUIDoc *document_;

	/** The root of the visible tree */
	Instance *root;

	/** Rebuild the tree view after the root has changed */
	void buildTree(Instance *root, QListViewItem *item);

	/** Maps list view items to instances */
	QPtrDict <Instance> map;
};

#endif // HIERARCHY_VIEW_H















