/***************************************************************************
                          colourvalue.h  -  description                              
                             -------------------                                         
    begin                : Thu Apr 8 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef COLOURVALUE_H
#define COLOURVALUE_H

#include <qstring.h>
#include <qpixmap.h>
#include <qcolor.h>
#include "value.h"

/**
  *@author Richard Moore
  */

class ColourValue : public Value  {
public: 
	ColourValue();
	~ColourValue();

	virtual ValueEditor *createEditor(QWidget *);

	/**
		* Convert the value to a string.
		*/
	virtual const char *toString();

	/**
		* Set the value from a string.
		*/
	virtual void fromString(const char *);

	virtual QPixmap *toPixmap(int width= 15, int height= 15);
	virtual bool hasPixmapView();

	void setColor(const QColor &c);
	const QColor &color();

protected:
	QString text_;
	QColor colour;
	QPixmap pix;
};

#endif



