/*
 *   kwrl - a little VRML 2.0 editor
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* local headers */
#include <SFToken.h>
#include <TextureTransform.h>

/*************************************************************************/
void TextureTransform::eventIn(SFString &eventType, SFNode *eventData)
{

#ifdef DEBUG_EVENTS
  cout << "\nEntered TextureTransform::eventIn (" << DEF << ")\n";
#endif 

    /* Determine what action to take based on incoming event */
  if ((eventType == "translation") || (eventType == "set_translation")) {
    SFVec2f *n = (SFVec2f *) eventData;
    translation = *n;

  } else if ((eventType == "rotation") || (eventType == "set_rotation")) {
    SFFloat *n = (SFFloat *) eventData;
    rotation = *n;

  } else if ((eventType == "scale") || (eventType == "set_scale")) {
    SFVec2f *n = (SFVec2f *) eventData;
    scale = *n;

  } else if ((eventType == "center") || (eventType == "set_center")) {
    SFVec2f *n = (SFVec2f *) eventData;
    center = *n;

  }

}
/*************************************************************************/

/*************************************************************************/
void TextureTransform::render(SFRenderInfo &)
{

#ifdef DEBUG_RENDER
  cout << "\nEntered TextureTransform::render (" << DEF << ")\n";
#endif 

  /* store the current TextureTransformation */
  glMatrixMode(GL_TEXTURE);  
  glLoadIdentity();

  /* adjust the center of rotation and scale */
  glTranslated(-translation[0], -translation[1], 0.0);

  /* apply the scale */
  glScaled(scale[0], scale[1], 1.0);

  /* apply the rotation */
  glRotated(0, 0, 1, rotation);

  /* unadjust the center of rotation and scale */
  glTranslated(translation[0], translation[1],  0.0);

  /* apply the TextureTransform */
  glTranslated(translation[0], translation[1], 0.0);

  /* restore to the modelview matrix */
  glMatrixMode(GL_MODELVIEW);

}
/*************************************************************************/

/*************************************************************************/
void TextureTransform::parse(char *header, istream &InFile)
{

  /* we are valid */
  isValid() = true;

  /* a token in the file */
  SFToken Token;

  /* the required labels */
  bool TokenFound          = false;
  bool BeginBracketFound   = false;

  /* commence to search for the matching bracket */
  while (! InFile.eof()) {
    
    /* Remember where the token started from */
    Token.GetToken(InFile);

#ifdef DEBUG_PARSE
    cout << "\tTextureTransform: (" << Token() << ")\n";
#endif

    /* based on what token was found, continue parsing */
    if (Token == "DEF") {
      Token.GetToken(InFile);
      DEF = Token();

    } else if (Token == "USE") {
      Token.GetToken(InFile);
      USE = Token();
      unsatisfiedUSE() = true;
      return;

    } else if (Token ==  "NULL") {
      isValid() = false;
      return;

    } else if (Token == "translation") {
      translation.parse(header, InFile);

    } else if (Token == "rotation") {
      rotation.parse(header, InFile);

    } else if (Token == "scale") {
      scale.parse(header, InFile);

    } else if (Token == "center") {
      center.parse(header, InFile);

    } else if (Token == "TextureTransform") {
      TokenFound = true;

    } else if (Token == "{") {
      BeginBracketFound = true;

    } else if (Token == "}") {
      break;
      
    } else {
      parseWarning(Token());

    }
  }

  /* if we did not find the material token we are in trouble */
  if (TokenFound == false) {
    cerr << "\nError:\n";
    cerr << "\tOccurred in (" << nodeType() << "::parse())\n";
    cerr << "\tDid not find expected identifier token.\n";
    exit(0);
  }
  if (BeginBracketFound == false) {
    cerr << "\nError:\n";
    cerr << "\tOccurred in (" << nodeType() << "::parse())\n";
    cerr << "\tDid not find expected \"{\" token.\n";
    exit(0);
  }
}
/*************************************************************************/

