/*
 *   kwrl - a little VRML 2.0 editor
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* local headers */
#include <SFToken.h>
#include <Texture.h>

/*************************************************************************/
void Texture::prepare(SFVec3f &min, SFVec3f &max)
{

#ifdef DEBUG_PREPARE
  cout << "\nEntered Texture::prepare (" << DEF << ")\n";
#endif 

  /* prepare */
  if      (imageTexture.isValid()) imageTexture.prepare(min, max);
  else if (pixelTexture.isValid()) pixelTexture.prepare(min, max);
  else if (movieTexture.isValid()) movieTexture.prepare(min, max);

}
/*************************************************************************/

/*************************************************************************/
void Texture::render(SFRenderInfo &SFRI)
{

#ifdef DEBUG_RENDER
    cout << "\tEntered Texture::render\n";
#endif

  /* render the texture */
  if      (imageTexture.isValid()) imageTexture.render(SFRI);
  else if (pixelTexture.isValid()) pixelTexture.render(SFRI);
  else if (movieTexture.isValid()) movieTexture.render(SFRI);
  
}
/*************************************************************************/

/*************************************************************************/
void Texture::parse(char *header, istream &InFile)
{

  /* we are valid */
  isValid() = true;

  /* a token in the file */
  SFToken Token;

  /* commence to search for the matching bracket */
  while (! InFile.eof()) {
    
    /* Remember where the token started from */
    streampos p = Token.GetToken(InFile);

#ifdef DEBUG_PARSE
    cout << "\tTexture: (" << Token() << ")\n";
#endif

    /* based on what token was found, continue parsing */
    if (Token == "DEF") {
      Token.GetToken(InFile);
      DEF = Token();

    } else if (Token == "USE") {
      Token.GetToken(InFile);
      USE = Token();
      unsatisfiedUSE() = true;
      return;

    } else if (Token ==  "NULL") {
      isValid() = false;
      return;

    } else if (Token ==  "ImageTexture") {
      imageTexture.parse(header, InFile.seekg(p));
      return;

    } else if (Token == "PixelTexture") {
      pixelTexture.parse(header, InFile.seekg(p));
      return;

    } else if (Token == "MovieTexture") {
      movieTexture.parse(header, InFile.seekg(p));
      return;

    } else if (Token == "}") {
      break;
      
    } else {
      parseWarning(Token());

    }
  }
}
/*************************************************************************/
