/*
 *   kwrl - a little VRML 2.0 editor
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* local headers */
#include <SFToken.h>
#include <SFFloat.h>

/*************************************************************************/
void SFFloat::parse(char *, istream &InFile)
{

  /* we are valid */
  isValid() = true;
  
  /* The current token */
  SFToken Token;

  /* continue until a valid int is found - skip commas and stuff */
  while (! InFile.eof()) {

    /* read a token */
    Token.GetToken(InFile);

#ifdef DEBUG_PARSE_LOWEST
    cout << "\tSFFloat: (" << Token() << ")\n";
#endif
    
    /* convert that string into a float */
    if (Token.isSFFloat()) {
      data = atof(Token());
      break;
    }
  }
}
/*************************************************************************/
