/*
 *   kwrl - a little VRML 2.0 editor
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* local headers */
#include <SFToken.h>
#include <SFEvent.h>

/*************************************************************************/
void SFEvent::parse(char *, istream &InFile)
{

  /* a token in the file */
  SFToken Token;

  /* Get the from field */
  Token.GetToken(InFile);

  /* The first part of the event consists of an event def name */
  char *c;
  int ti = 0;
  for (c = Token(); ((*c != '\0') && (*c != '.') && (ti < 1023)); c++, ti++) {
    nodeFromName().value(ti) = *c;
  }
  nodeFromName().value(ti) = '\0';
  
  /* The second part of the from event has the event name */  
  for (c++, ti = 0; ((*c != '\0') && (*c != '.') && (ti < 1023)); c++, ti++) {
    eventFromName().value(ti) = *c;
  }
  eventFromName().value(ti) = '\0';

  /* now we should see a TO token */
  Token.GetToken(InFile);
  if (Token != "TO") {
    cerr << "Bad Token Found (" << Token() << ") (" << "TO" << ")\n";
    parseWarning(Token());    
  }

  /* Get the to field */
  Token.GetToken(InFile);

  /* The first part of the event consists of an event def name */
  ti = 0;
  for (c = Token(); ((*c != '\0') && (*c != '.') && (ti < 1023)); c++, ti++) {
    nodeToName().value(ti) = *c;
  }
  nodeToName().value(ti) = '\0';

  /* The second part of the from event has the event name */  
  for (c++, ti = 0; ((*c != '\0') && (*c != '.') && (ti < 1023)); c++, ti++) {
    eventToName()[ti] = *c;
  }
  eventToName()[ti] = '\0';

#ifdef DEBUG_PARSE
  cout << "\tSFEvent:\n";
  cout << "\t\tFROM (" << nodeFromName() << ") (";
  cout << eventFromName() << ")\n";
  cout << "\t\tTO (" << nodeToName() << ") (";
  cout << eventToName() << ")\n";
#endif

}
/*************************************************************************/





