/*
 *   kwrl - a little VRML 2.0 editor
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* local headers */
#include <SFToken.h>
#include <Geometry.h>

/*************************************************************************/
void Geometry::prepare (SFVec3f &min, SFVec3f &max)
{

#ifdef DEBUG_PREPARE
  cout << "\nEntered Geometry::prepare (" << DEF << ")\n";
#endif 

  /* prepare the appropriate geometry */
  if      (indexedFaceSet.isValid()) indexedFaceSet.prepare(min, max);
  else if (indexedLineSet.isValid()) indexedLineSet.prepare(min, max);
  else if (pointSet.isValid())       pointSet.prepare(min, max);
  else if (sphere.isValid())         sphere.prepare(min, max);
  else if (box.isValid())            box.prepare(min, max);
  else if (cylinder.isValid())       cylinder.prepare(min, max);
  else if (cone.isValid())           cone.prepare(min, max);
  else if (elevationGrid.isValid())  elevationGrid.prepare(min, max);
  else if (text.isValid())           text.prepare(min, max);   
  else if (extrusion.isValid())      extrusion.prepare(min, max);

}
/*************************************************************************/

/*************************************************************************/
void Geometry::render(SFRenderInfo &SFRI)
{

#ifdef DEBUG_RENDER
  cout << "\nEntered Geometry::render (" << DEF << ")\n";
#endif 

  /* draw the appropriate geometry */
  if      (indexedFaceSet.isValid()) indexedFaceSet.render(SFRI);
  else if (indexedLineSet.isValid()) indexedLineSet.render(SFRI);
  else if (pointSet.isValid())       pointSet.render(SFRI);
  else if (sphere.isValid())         sphere.render(SFRI);
  else if (box.isValid())            box.render(SFRI);
  else if (cylinder.isValid())       cylinder.render(SFRI);
  else if (cone.isValid())           cone.render(SFRI);
  else if (elevationGrid.isValid())  elevationGrid.render(SFRI);
  else if (text.isValid())           text.render(SFRI);   
  else if (extrusion.isValid())      extrusion.render(SFRI);

#ifdef DEBUG_RENDER
  cout << "\t" << gluErrorString(glGetError()) << "\n";  
#endif
  
}
/*************************************************************************/

/*************************************************************************/
void Geometry::parse(char *header, istream &InFile)
{

  /* we are valid */
  isValid() = true;

  /* a token in the file */
  SFToken Token;

  /* continue to read until a geometry node is successfully found */
  while (! InFile.eof()) {

    /* Remember where the token started from */
    streampos p = Token.GetToken(InFile);
    
#ifdef DEBUG_PARSE    
    cout << "\tGeometry: (" << Token() << ")\n";
#endif
    
    /* based on what token was found, continue parsing */
    if (Token == "DEF") {
      Token.GetToken(InFile);
      DEF = Token();

    } else if (Token == "USE") {
      Token.GetToken(InFile);
      USE = Token();
      unsatisfiedUSE() = true;
      return;

    } else if (Token == "IndexedFaceSet") {
      indexedFaceSet.parse(header, InFile.seekg(p));
      return;

    } else if (Token == "IndexedLineSet") {
      indexedLineSet.parse(header, InFile.seekg(p));
      return;

    } else if (Token ==  "PointSet") {
      pointSet.parse(header, InFile.seekg(p));
      return;

    } else if (Token == "Sphere") {
      sphere.parse(header, InFile.seekg(p));
      return;
      
    } else if (Token == "Box") {
      box.parse(header, InFile.seekg(p));
      return;

    } else if (Token == "Cylinder") {
      cylinder.parse(header, InFile.seekg(p));
      return;
      
    } else if (Token == "Cone") {
      cone.parse(header, InFile.seekg(p));
      return;
      
    } else if (Token == "ElevationGrid") {
      elevationGrid.parse(header, InFile.seekg(p));
      return;
      
    } else if (Token == "Text") {
      text.parse(header, InFile.seekg(p));
      return;
      
    } else if (Token == "Extrusion") {
      extrusion.parse(header, InFile.seekg(p));
      return;
      
    } else {
      parseWarning(Token());
      
    }
  }
}
/*************************************************************************/
