/*
 *   kwrl - a little VRML 2.0 editor
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* local headers */
#include <SFToken.h>
#include <SFString.h>
#include <SFRotation.h>
#include <SFEvent.h>
#include <Children.h>
#include <AudioClip.h>

/*************************************************************************/
void AudioClip::prepare (SFVec3f &min, SFVec3f &max)
{

#ifdef DEBUG_PREPARE
  cout << "\nEntered AudioClip::prepare (" << DEF << ")\n";
#endif 

  /* prepare the description */
  if (description.isValid()) description.prepare(min, max);

  /* prepare the loop */
  if (loop.isValid()) loop.prepare(min, max);

  /* prepare the pitch */
  if (pitch.isValid()) pitch.prepare(min, max);

  /* prepare the startTime */
  if (startTime.isValid()) startTime.prepare(min, max);

  /* prepare the stop time */
  if (stopTime.isValid()) stopTime.prepare(min, max);

  /* prepare the url */
  if (url.isValid()) url.prepare(min, max);

}
/*************************************************************************/

/*************************************************************************/
void AudioClip::render(SFRenderInfo &)
{

#ifdef DEBUG_RENDER
  cout << "\nEntered AudioClip::render (" << DEF << ")\n";
#endif 

}
/*************************************************************************/

/*************************************************************************/
void AudioClip::eventIn(SFString &eventType, SFNode *eventData)
{

#ifdef DEBUG_EVENTS
  cout << "\nEntered AudioClip::eventIn (" << DEF << ")\n";
#endif 

  /* Determine what action to take based on incoming event */
  if        ((eventType == "description")    || (eventType == "set_description")) {
    SFString *n = (SFString *) eventData;
    description = *n;
    
  } else if ((eventType == "loop") || (eventType == "set_loop")) {
    SFBool *n = (SFBool *) eventData;
    loop = *n;

  } else if ((eventType == "pitch") || (eventType == "set_pitch")) {
    SFFloat  *n = (SFFloat *) eventData;
    pitch = *n;

  } else if ((eventType == "startTime") || (eventType == "set_startTime")) {
    SFTime  *n = (SFTime *) eventData;
    startTime = *n;

  } else if ((eventType == "stopTime") || (eventType == "set_stopTime")) {
    SFTime  *n = (SFTime *) eventData;
    stopTime = *n;

  }
}
/*************************************************************************/

/*************************************************************************/
void AudioClip::eventOut(SFString &, SFNode *)
{

#ifdef DEBUG_EVENTS
  cout << "\nEntered AudioClip::eventOut (" << DEF << ")\n";
#endif 

}
/*************************************************************************/

/*************************************************************************/
void AudioClip::parse(char *header, istream &InFile)
{

  /* a token in the file */
  SFToken Token;

  /* the required labels */
  bool TokenFound  = false;
  bool BeginBracketFound   = false;

  /* commence to search for the matching bracket */
  while (! InFile.eof()) {
    
    /* Remember where the token started from */
    Token.GetToken(InFile);

#ifdef DEBUG_PARSE
    cout << "\tAudioClip: (" << Token() << ")\n";
#endif

    /* based on what token was found, continue parsing */
    if (Token == "DEF") {
      Token.GetToken(InFile);
      DEF = Token();

    } else if (Token == "USE") {
      Token.GetToken(InFile);
      USE = Token();
      unsatisfiedUSE() = true;
      return;

    } else if (Token == "description") {
      description.parse(header, InFile);

    } else if (Token == "loop") {
      loop.parse(header, InFile);

    } else if (Token == "pitch") {
      pitch.parse(header, InFile);

    } else if (Token == "startTime") {
      startTime.parse(header, InFile);

    } else if (Token == "stopTime") {
      stopTime.parse(header, InFile);

    } else if (Token == "url") {
      url.parse(header, InFile);

    } else if (Token == "AudioClip") {
      TokenFound = true;

    } else if (Token == "{") {
      BeginBracketFound = true;

    } else if (Token == "}") {
      break;
      
    } else {
      parseWarning(Token());

    }
  }

  /* if we did not find the material token we are in trouble */
  if (TokenFound == false) {
    cerr << "\nError:\n";
    cerr << "\tOccurred in (" << nodeType() << "::parse())\n";
    cerr << "\tDid not find expected identifier token.\n";
    exit(0);
  }
  if (BeginBracketFound == false) {
    cerr << "\nError:\n";
    cerr << "\tOccurred in (" << nodeType() << "::parse())\n";
    cerr << "\tDid not find expected \"{\" token.\n";
    exit(0);
  }

}
/*************************************************************************/

