/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef TRANSFORM
#define TRANSFORM

// label
#define TransformLabel "Transform"

// classes
#include <SFNode.h>
#include <SFVec3f.h>
#include <SFRotation.h>
#include <Children.h>

// class definition
class Transform : public SFNode {

 public:

  // constructor
  Transform() : SFNode(TransformLabel) {
    bboxCenter[0]       =  0.0;
    bboxCenter[1]       =  0.0;
    bboxCenter[2]       =  0.0;
    bboxSize[0]         = -1.0;
    bboxSize[1]         = -1.0;
    bboxSize[2]         = -1.0;
    translation[0]      =  0.0;
    translation[1]      =  0.0;
    translation[2]      =  0.0;
    scale[0]            =  1.0;
    scale[1]            =  1.0;
    scale[2]            =  1.0;
    scaleOrientation[0] =  0.0;
    scaleOrientation[1] =  0.0;
    scaleOrientation[2] =  1.0;
    scaleOrientation[3] =  0.0;
    center[0]           =  0.0;
    center[1]           =  0.0;
    center[2]           =  0.0;
    rotation[0]         =  0.0;
    rotation[1]         =  0.0;
    rotation[2]         =  1.0;
    rotation[3]         =  0.0;
  }
    
  // destructor
  ~Transform() {
  }

  // parse
  void parse   (char         *, istream      &);

  // prepare
  void prepare (SFVec3f      &, SFVec3f &);

  // render
  void render  (SFRenderInfo &);

  // events
  void eventIn (SFString     &, SFNode *);

  // operators
  Transform &operator = (Transform &T2) {
    translation        = T2.translation;
    scale              = T2.scale;
    center             = T2.center;
    rotation           = T2.rotation;
    scaleOrientation   = T2.scaleOrientation;
    bboxCenter         = T2.bboxCenter;
    bboxSize           = T2.bboxSize;
    children           = T2.children;
    isValid()          = T2.isValid();
    return(*this);
  }

  // Queue
  void push(Children &stack, SFString &stackType) {
    if (stackType == nodeType()) stack.add(this);
    else children.push(stack, stackType);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return(children.findDEF(UnsatUSE));
  }
  SFNode *findUSE() {
    if (unsatisfiedUSE()) return(this);
    return(children.findUSE());
  }
  SFString *use() {
    return(&USE);
  }

 protected:

  // create a compact matrix
  void createMatrix();

 private:

  // data
  SFVec3f     translation;
  SFRotation  rotation;
  SFVec3f     scale;
  SFRotation  scaleOrientation;
  SFVec3f     center;
  SFVec3f     bboxCenter;
  SFVec3f     bboxSize;
  Children    children;

  // USE-DEF
  SFString    DEF;
  SFString    USE;

  // internal efficiency
  GLdouble m[16];

};

#endif // Transform
