/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef TEXTURETRANSFORM
#define TEXTURETRANSFORM

// label
#define TextureTransformLabel "TextureTransform"

// classes
#include <SFNode.h>
#include <SFFloat.h>
#include <SFVec2f.h>
#include <SFString.h>

// class definition
class TextureTransform : public SFNode {

 public:

  // constructor
  TextureTransform() : SFNode(TextureTransformLabel) {
    translation[0] = 0.0;
    translation[1] = 0.0;
    rotation       = 0.0;
    scale[0]       = 1.0;
    scale[1]       = 1.0;
    center[0]      = 0.0;
    center[1]      = 0.0;
  }
    
  // destructor
  ~TextureTransform() {
  }

  // parse
  void parse (char         *, istream      &);

  // render
  void render(SFRenderInfo &);

  // events
  void eventIn (SFString   &, SFNode *);

  // operators
  TextureTransform &operator = (TextureTransform &T2) {
    translation              = T2.translation;
    scale                    = T2.scale;
    center                   = T2.center;
    rotation                 = T2.rotation;
    isValid()                = T2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

 protected:

 private:

  // data
  SFVec2f    translation;
  SFFloat    rotation;
  SFVec2f    scale;
  SFVec2f    center;

  // USE-DEF
  SFString DEF;
  SFString USE;

};

#endif // TextureTransform
