/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef SFVEC3F
#define SFVEC3F

// label
#define SFVec3fLabel "SFVec3f"

// classes
#include <SFNode.h>
#include <SFFloat.h>

// class definition
class SFVec3f : public SFNode {
  
 public:
  
  // constructor
  SFVec3f() : SFNode(SFVec3fLabel) {
  }

  // destructor
  ~SFVec3f() {
  }

  // parse
  void parse   (char *, istream      &);

  // operators
  SFVec3f &operator = (SFVec3f &S2) {
    data[0] = S2[0];
    data[1] = S2[1];
    data[2] = S2[2];
    return(*this);
  }

  // access
  SFFloat & operator [] (unsigned int i) {
    if      (i == 0) return(data[0]);
    else if (i == 1) return(data[1]); 
    return(data[2]); 
  }
  
  // vector operations
  double length() {
    double a = data[0]();
    double b = data[1]();
    double c = data[2]();
    return(sqrt(a*a + b*b + c*c));
  }
  void normalize() {
    double l = length();
    data[0] /= l;
    data[1] /= l;
    data[2] /= l;
  }

 protected:

 private:

  // data
  SFFloat data[3];

};

#endif // SFVEC3F
