/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef SFTOKEN
#define SFTOKEN

// C++ includes
#include <stdlib.h>
#include <iostream.h>

// class definition
class SFToken {

 public:

  // constructor
  SFToken() {
    strcpy(data, "\0");
  }
  
  // destructor
  ~SFToken() {
  }

  // parse
  streampos GetToken(istream &);
  
  // access
  char *operator () () {
    return(data);
  }

  // operators
  friend char operator == (SFToken &S, char *t) {
    return(strcmp(S.data, t) == 0);
  }
  friend char operator != (SFToken &S, char *t) {
    return(strcmp(S.data, t) != 0);
  }

  // the type of the current token
  bool isSFInt32();
  bool isSFFloat();
  bool isSFString();

 protected:

 private:

  // data
  char data[1024];

};

#endif // SFToken




