/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef SFSTRING
#define SFSTRING

// C includes
#include <math.h>
#include <string.h>
#include <ctype.h>

// C++ includes
#include <stdlib.h>
#include <iostream.h>

// classes
#include <SFNode.h>

// label
#define SFStringLabel "SFString"

// class definition
class SFString : public SFNode {

 public:

  // constructor
  SFString() : SFNode(SFStringLabel) {
    strcpy(data, "\0");
  }
  SFString(char *n) : SFNode(SFStringLabel) {
    strcpy(data, n);
  }
  
  // destructor
  ~SFString() {
  }

  // parse
  void parse(char *, istream &);

  // access the data
  operator char * () {
    return(data);
  }
  char &value(int i) {
    if ((i < 0) || (i >= 1024)) {
      cerr << "\nError:\n";
      cerr << "\tOccurred in SFString::value\n";
      cerr << "\tOut of array bounds access (" << i << ")";
      cerr << " of (" << 1024 << ")\n";
      exit(0);
    }
    return(data[i]);
  }

  // operators
  int length() {
    return(strlen(data));
  }
  friend ostream & operator << (ostream &o, SFString &S1) {
    o << S1.data;
    return(o);
  }
  friend char operator == (SFString &S1, char *S2) {
    return(strcmp(S1.data, S2) == 0);
  }
  friend char operator != (SFString &S1, char *S2) {
    return(strcmp(S1.data, S2) != 0);
  }
  friend char operator == (SFString &S1, SFString &S2) {
    return(strcmp(S1.data, S2.data) == 0);
  }
  friend char operator != (SFString &S1, SFString &S2) {
    return(strcmp(S1.data, S2.data) != 0);
  }
  SFString &operator = (SFString &S2) {
    strncpy(data, S2.data, 1024);
    return(*this);
  }
  SFString &operator = (char *S2) {
    strncpy(data, S2, 1024);
    return(*this);
  }
  SFString &operator += (SFString &S2) {
    strncat(data, S2.data, 1024);
    return(*this);
  }
  SFString &operator += (char *S2) {
    strncat(data, S2, 1024);
    return(*this);
  }

 protected:

 private:

  // the data
  char data[1024];

};

#endif // SFString
