/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef SFRENDERINFO
#define SFRENDERINFO

// classes
#include <SFFloat.h>
#include <SFInt32.h>
#include <SFVec3f.h>
#include <SFTime.h>

// class definition
class SFRenderInfo {

 public:

  // constructor
  SFRenderInfo() {
  }
  
  // destructor
  ~SFRenderInfo() {
  }

  // access
  SFInt32 &w() {
    return(privateWidth);
  }
  SFInt32 &h() {
    return(privateHeight);
  }
  SFFloat &fov() {
    return(privateFov);
  }
  SFFloat &farPlane() {
    return(privateFarPlane);
  }
  SFFloat &nearPlane() {
    return(privateNearPlane);
  }
  SFVec3f &eye() {
    return(privateEye);
  }
  SFVec3f &min() {
    return(privateMin);
  }
  SFVec3f &max() {
    return(privateMax);
  }
  SFTime  &time() {
    return(privateTime);
  }

 protected:

 private:

  // data
  SFInt32 privateWidth;
  SFInt32 privateHeight;
  SFFloat privateFov;
  SFFloat privateFarPlane;
  SFFloat privateNearPlane;
  SFVec3f privateEye;
  SFVec3f privateMin;
  SFVec3f privateMax;
  SFTime  privateTime;

};

#endif // SFRenderInfo




