/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef POINTSET
#define POINTSET

// label
#define PointSetLabel "PointSet"

// classes
#include <SFNode.h>
#include <Color.h>
#include <Coordinate.h>

// class definition
class PointSet : public SFNode {

public:

  // constructor
  PointSet() : SFNode(PointSetLabel) {
  }

  // destructor
  ~PointSet() {
  }

  // parse
  void parse   (char         *, istream      &);

  // prepare
  void prepare (SFVec3f      &, SFVec3f      &);

  // render
  void render  (SFRenderInfo &);

  // events
  void eventIn (SFString     &, SFNode       *);

  // operators
  PointSet &operator = (PointSet &P2) {
    color            = P2.color;
    coord            = P2.coord;
    isValid()        = P2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findUSE() {
    SFNode *MFN = (SFNode *) this;
    if (unsatisfiedUSE()) {
      MFN = (SFNode *) this;
    } else {
      MFN = coord.findUSE();
      if (MFN == (SFNode *) 0) {
	MFN = color.findUSE();
      }
    }   
    return(MFN);
  }
  SFNode *findDEF(SFString &UnsatUSE) {
    SFNode *MFN = (SFNode *) 0;
    if (UnsatUSE == DEF) {
      MFN = (SFNode *) this;
    } else {
      MFN = coord.findDEF(UnsatUSE);
      if (MFN == (SFNode *) 0) {
	MFN = color.findDEF(UnsatUSE);
      }
    }
    return(MFN);
  }
  SFString *use() {
    return(&USE);
  }

protected:

private:

  // data 
  Color      color;
  Coordinate coord;

  // USE-DEF
  SFString   DEF;
  SFString   USE;

};

#endif // PointSet
