/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef NORMAL
#define NORMAL

// label
#define NormalLabel               "normal"

// classes
#include <SFNode.h>
#include <MFVec3f.h>
#include <SFString.h>

// class definition
class Normal : public SFNode {

 public:

  // constructor
  Normal() : SFNode(NormalLabel) {
  }
  
  // destructor
  ~Normal() {
  }

  // parse
  void parse   (char     *, istream &);

  // events
  void eventIn (SFString &, SFNode *);

  // operators
  Normal &operator = (Normal &N2) {
    vector         = N2.vector;
    isValid()      = N2.isValid();
    return(*this);
  }
  SFVec3f  & operator [] (int i) {
    return(vector[i]);
  }
  int num() {
    return(vector.num());
  }

  // allocate
  void alloc(int n) {
    vector.alloc(n);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

 protected:

 private:

  // data
  MFVec3f vector;

  // USE-DEF
  SFString DEF;
  SFString USE;

};

#endif // Normal





