/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef MFVEC2F
#define MFVEC2F

// label
#define MFVec2fLabel "MFVec2f"

// classss
#include <SFNode.h>
#include <SFVec2f.h>

// class definition
class MFVec2f : public SFNode {

 public:

  // constructor
  MFVec2f() : SFNode(MFVec2fLabel) {
    numElements = 0;
    data        = (SFVec2f *) 0;
  }
  
  // destructor
  ~MFVec2f() {
    if (data != (SFVec2f *) 0) delete[] data;    
    numElements = 0;
    data        = (SFVec2f *) 0;
  }

  // parse
  void parse(char *, istream &);

  // operators
  MFVec2f &operator = (MFVec2f &M2) {
    alloc(M2.numElements);
    for (int i = 0; i < M2.numElements; i++) data[i] = M2.data[i];
    isValid() = M2.isValid();
    return(*this);
  }

  // access
  int num() {
    return(numElements);
  }
  SFVec2f  & operator [] (int i) {
    if ((i < 0) || (i >= numElements)) {
      cerr << "\nError:\n";
      cerr << "\tOccurred in MFVec2F::operator()\n";
      cerr << "\tOut of array bounds access (" << i << ")";
      cerr << " of (" << numElements << ")\n";
      exit(0);
    }
    return(data[i]);
  }

  // allocate
  void alloc (int n) {
    numElements = n;
    data        =  new SFVec2f[n];
    if (data   == (SFVec2f *) 0) {  
      cerr << "\nError:\n";
      cerr << "\tOccurred in MFVec2F::alloc(" << n << ")\n";
      cerr << "\tCould not allocate requested memory\n";
      exit(0);
    }
  }

 protected:

 private:

  // data
  int      numElements;
  SFVec2f *data;

};

#endif // MFVEC2F
