/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef GEOMETRY
#define GEOMETRY

// label
#define GeometryLabel "Geometry"

// classes
#include <SFNode.h>
#include <IndexedFaceSet.h>
#include <IndexedLineSet.h>
#include <Cone.h>
#include <Box.h>
#include <Extrusion.h>
#include <Cylinder.h>
#include <PointSet.h>
#include <ElevationGrid.h>
#include <Sphere.h>
#include <Text.h>

// class definition
class Geometry : public SFNode {

 public:

  // constructor
  Geometry():SFNode(GeometryLabel) {
  }

  // destructor
  ~Geometry() {
  }

  // parse
  void parse   (char         *, istream      &);

  // prepare
  void prepare (SFVec3f      &, SFVec3f      &);
    
  // render
  void render  (SFRenderInfo &);

  // operators
  Geometry &operator = (Geometry &G2) {
    indexedFaceSet   = G2.indexedFaceSet;
    indexedLineSet   = G2.indexedLineSet;
    pointSet         = G2.pointSet;
    sphere           = G2.sphere;
    box              = G2.box;
    cylinder         = G2.cylinder;
    cone             = G2.cone;
    extrusion        = G2.extrusion;
    text             = G2.text;
    elevationGrid    = G2.elevationGrid;
    isValid()        = G2.isValid;
    return(*this);
  }

  // USE-DEF
  SFNode *findUSE() {
    SFNode *MFN = (SFNode *) 0;
    if (unsatisfiedUSE()) {
      MFN = (SFNode *) this;
    } else {
      MFN = indexedFaceSet.findUSE();
      if (MFN == (SFNode *) 0) {
	MFN = indexedLineSet.findUSE();
	if (MFN == (SFNode *) 0) {
	  MFN = pointSet.findUSE();
	  if (MFN == (SFNode *) 0) {
	    MFN = sphere.findUSE();
	    if (MFN == (SFNode *) 0) {
	      MFN = box.findUSE();
	      if (MFN == (SFNode *) 0) {
		MFN = cylinder.findUSE();
		if (MFN == (SFNode *) 0) {
		  MFN = cone.findUSE();
		  if (MFN == (SFNode *) 0) {
		    MFN = elevationGrid.findUSE();
		    if (MFN == (SFNode *) 0) {
		      MFN = text.findUSE();
		      if (MFN == (SFNode *) 0) {
			MFN = extrusion.findUSE();
		      }
		    }
		  }
		}
	      }
	    }
	  }
	}
      }
    }
    return(MFN);    
  }
  SFNode *findDEF(SFString &UnsatUSE) {
    SFNode *MFN = (SFNode *) 0;
    if (UnsatUSE == DEF) {
      MFN = (SFNode *) this;
    } else {
      MFN = indexedFaceSet.findDEF(UnsatUSE);
      if (MFN == (SFNode *) 0) {
	MFN = indexedLineSet.findDEF(UnsatUSE);
	if (MFN == (SFNode *) 0) {
	  MFN = pointSet.findDEF(UnsatUSE);
	  if (MFN == (SFNode *) 0) {
	    MFN = sphere.findDEF(UnsatUSE);
	    if (MFN == (SFNode *) 0) {
	      MFN = box.findDEF(UnsatUSE);
	      if (MFN == (SFNode *) 0) {
		MFN = cylinder.findDEF(UnsatUSE);
		if (MFN == (SFNode *) 0) {
		  MFN = cone.findDEF(UnsatUSE);
		  if (MFN == (SFNode *) 0) {
		    MFN = elevationGrid.findDEF(UnsatUSE);
		    if (MFN == (SFNode *) 0) {
		      MFN = text.findDEF(UnsatUSE);
		      if (MFN == (SFNode *) 0) {
			MFN = extrusion.findDEF(UnsatUSE);
		      }
		    }
		  }
		}
	      }
	    }
	  }
	}
      }
    }
    return(MFN);    
  }
  SFString *use() {
    return(&USE);
  }

 protected:

 private:

  // data
  IndexedFaceSet indexedFaceSet;
  IndexedLineSet indexedLineSet;
  PointSet       pointSet;
  Sphere         sphere;
  Box            box;
  Cylinder       cylinder;
  Cone           cone;
  ElevationGrid  elevationGrid;
  Text           text;
  Extrusion      extrusion;

  // USE-DEF
  SFString       DEF;
  SFString       USE;

};

#endif // Geometry
