/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef FONTSTYLE
#define FONTSTYLE

// label
#define FontStyleLabel "FontStyle"

// classes
#include <SFNode.h>
#include <SFFloat.h>
#include <SFBool.h>
#include <SFString.h>
#include <MFString.h>

// class definition
class FontStyle : public SFNode {

public:

  // constructor
  FontStyle() : SFNode(FontStyleLabel) {
    size     = 1.0;
    spacing  = 1.0;
    family   = "SERIF";
    style    = "PLAIN";
    language = "\0";
  }

  // destructor
  ~FontStyle() {
  }

  // parse
  void parse(char *, istream &);

  // render
  void render(char s);

  // operators
  FontStyle &operator = (FontStyle &F2) {
    size              = F2.size;
    spacing           = F2.spacing;
    family            = F2.family;
    style             = F2.style;
    horizontal        = F2.horizontal;
    leftToRight       = F2.leftToRight;
    topToBottom       = F2.topToBottom;
    language          = F2.language;
    justify           = F2.justify;
    isValid()         = F2.isValid();
    return(*this);
  }
  float operator ()() {
    return(size);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

protected:

private:

  // data
  SFFloat   size;
  SFFloat   spacing;
  SFString  family;
  SFString  style;
  SFBool    horizontal;
  SFBool    leftToRight;
  SFBool    topToBottom;
  SFString  language;
  MFString  justify;

  // USE-DEF
  SFString DEF;
  SFString USE;

};

#endif // FontStyle
