/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef EXTRUSION
#define EXTRUSION

// label
#define ExtrusionLabel "Extrusion"

// classes
#include <SFNode.h>
#include <SFBool.h>
#include <SFFloat.h>
#include <Color.h>
#include <Normal.h>
#include <Coordinate.h>
#include <MFVec3f.h>
#include <MFVec2f.h>
#include <MFRotation.h>
#include <SFString.h>

// class definition
class Extrusion : public SFNode {

public:

  // constructor
  Extrusion():SFNode(ExtrusionLabel) {
    beginCap    = true;
    endCap      = true;
    ccw         = true;
    solid       = true;
    convex      = true;
    creaseAngle = 0.0;
  }

  // destructor
  ~Extrusion() {
  }

  // parse
  void parse   (char         *, istream      &);

  // prepare
  void prepare (SFVec3f      &, SFVec3f      &);
    
  // render
  void render  (SFRenderInfo &);

  // events
  void eventIn (SFString     &, SFNode *);

  // operators
  Extrusion &operator = (Extrusion &E2) {
    spine             = E2.spine;
    crossSection      = E2.crossSection;
    scale             = E2.scale;
    orientation       = E2.orientation;
    beginCap          = E2.beginCap;
    endCap            = E2.endCap;
    ccw               = E2.ccw;
    solid             = E2.solid;
    convex            = E2.convex;
    creaseAngle       = E2.creaseAngle;
    coord             = E2.coord;
    normal            = E2.normal;
    isValid()         = E2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

protected:

private:

  // data
  MFVec3f     spine;
  MFVec2f     crossSection;
  MFVec2f     scale;
  MFRotation  orientation;
  SFBool      beginCap;
  SFBool      endCap;
  SFBool      ccw;
  SFBool      solid;
  SFBool      convex;
  SFFloat     creaseAngle;
  Coordinate  coord;
  Normal      normal;

  // USE-DEF
  SFString DEF;
  SFString USE;

};

#endif // Extrusion
