/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef DIRECTIONALLIGHT
#define DIRECTIONALLIGHT

// label
#define DirectionalLightLabel "DirectionalLight"

// classes
#include <SFNode.h>
#include <SFBool.h>
#include <SFFloat.h>
#include <SFVec3f.h>
#include <SFColor.h>
#include <SFInt32.h>
#include <SFString.h>

// class definition
class DirectionalLight : public SFNode {

 public:

  // constructor
  DirectionalLight() : SFNode(DirectionalLightLabel) {
    direction[0]     =  0.0;
    direction[1]     =  0.0;
    direction[2]     = -1.0;
    on               =  true;
    intensity        =  1.0;
    ambientIntensity =  0.0;
    color[0]         =  1.0;
    color[1]         =  1.0;
    color[2]         =  1.0;
  }

  // destructor
  ~DirectionalLight() {
  }
  
  // Parse
  void parse   (char         *, istream      &);
    
  // render
  void render  (SFRenderInfo &);

  // events
  void eventIn (SFString     &, SFNode       *);

  // operators
  DirectionalLight &operator = (DirectionalLight &D2) {
    direction                = D2.direction;
    on                       = D2.on;
    intensity                = D2.intensity;
    ambientIntensity         = D2.ambientIntensity;
    color                    = D2.color;
    isValid()                = D2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

 protected:

 private:

  // data
  SFVec3f  direction;
  SFBool   on;
  SFFloat  intensity;
  SFFloat  ambientIntensity;
  SFColor  color;

  // USE-DEF
  SFString DEF;
  SFString USE;

};

#endif // DirectionalLight
