/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef COLLISION
#define COLLISION

// label
#define CollisionLabel "Collision"

// classes
#include <SFNode.h>
#include <SFVec3f.h>
#include <Children.h>
#include <SFBool.h>
#include <SFTime.h>

// class definition
class Collision : public SFNode {

 public:

  // constructor
  Collision() : SFNode(CollisionLabel) {
    collide       = true;
    bboxCenter[0] =  0.0;
    bboxCenter[1] =  0.0;
    bboxCenter[2] =  0.0;
    bboxSize[0]   = -1.0;
    bboxSize[1]   = -1.0;
    bboxSize[2]   = -1.0;
    collideTime   = -1.0;
  }
    
  // destructor
  ~Collision() {
  }

  // parse
  void parse   (char         *, istream      &);

  // prepare
  void prepare (SFVec3f      &, SFVec3f      &);

  // render
  void render  (SFRenderInfo &);

  // events
  void eventIn (SFString     &, SFNode *);
  void eventOut(SFString     &, SFNode *);

  // operators
  Collision &operator = (Collision &C2) {
    collide           = C2.collide; 
    proxy             = C2.proxy; 
    collideTime       = C2.collideTime;
    bboxCenter        = C2.bboxCenter;
    bboxSize          = C2.bboxSize;
    children          = C2.children;
    isValid()         = C2.isValid();
    return(*this);
  }

  // Queue
  void push(Children &stack, SFString &stackType) {
    if (stackType == nodeType()) stack.add(this);
    else children.push(stack, stackType);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return(children.findDEF(UnsatUSE));
  }
  SFNode *findUSE() {
    if (unsatisfiedUSE()) return(this);
    return(children.findUSE());
  }
  SFString *use() {
    return(&USE);
  }

 protected:

 private:

  // data
  Children  children;
  SFBool    collide;
  Children  proxy;
  SFVec3f   bboxCenter;
  SFVec3f   bboxSize;

  // event data
  SFTime    collideTime;

  // USE-DEF
  SFString DEF;
  SFString USE;

};

#endif // COLLISION
