/*
 *   kscan - a scanning program
 *   Copyright (C) 1998 Ivan Shvedunov
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef __KSCAN_H__
#define __KSCAN_H__

#include "enhancement.h"
#include <qmsgbox.h>
#include <ktopwidget.h>
#include <kmenubar.h>
#include <kapp.h>
#include <kiconloader.h>
#include <kconfig.h>
//#include <klocale.h>
#include "preview.h"

#define ID_XDIM 0
#define ID_YDIM 1
#define ID_DPI 2
#define ID_TYPE 4

#define OP_ACQUIRE "AcquireAtStart"
#define OP_BACKEND "Backend"
#define OP_MAXDPI  "MaxDPI"

class KScan : public KTopLevelWidget {
	Q_OBJECT
public:
	KScan();
	~KScan() {}
public slots:
	void enableDim();
        void disableDim();
	void changed1(const char *str);
	void changed2(const char *str);
	void changed3(const char *) {}
	void preferences();
	void updateDpi();
	void die() { close(); }
	void changeType(int i) {
		if(ch) return;
		if(i) s->setType(COLOR);
		else s->setType(GRAY);
	}
	void selectBackend();
	void enhancement() {
		if(!s->hasImage()) {
			printf("no image!\n");
			return;
		}
		printf("enhancement...\n");
		EnhancementDialog d(s);
		d.exec();
	}
	void finalScan()
        { if(!present) return; s->save(current_dpi); } //FIXME
protected:
	void closeEvent(QCloseEvent *ev);
private:
	Preview *s;
	int ch,changed,present;
	int current_dpi;
	KToolBar *toolbar,*imgsize;
	KMenuBar *menubar;
	//OPTIONS
	//Also max_dpi
	bool acquire_at_start;
	char backend[256];
	KConfig *kconf;
	//BIG,BIG,BIG FAT WARNING!!!! CHECK ENTRY LENGTH!!!!!
	//OTHERWISE BUFFER OVERRUN ATTACK MAY BE POSSIBLE!!!!
	void displayDpi() {
		char buf[100];
		sprintf(buf,"%d dpi",current_dpi);
		imgsize->setLinedText(ID_DPI,buf);
	}
};

#endif
