// -*- C++ -*-
//--------------------------------------------------------------------
// KRay Version 0.1
//
// File: vector.h
//
// Classes: Vector
//
// Purpose: Defines a 3-dimensional Vector class, needed for a lot of
// calculating.  The constants hanging around here don't really belong
// here, but the cleanup will be done for version 0.2
//--------------------------------------------------------------------
#ifndef __vector_h
#define __vector_h

#define LatPow          5
#define LatCnt          (1 << LatPow)
#define LatMask         (LatCnt - 1)
#define scal            128*LatCnt
#define nscal           2.0 / (255*128*128*128)
#define mins            0.0001

typedef unsigned short LatTyp[LatMask + 1][LatMask + 1][LatMask + 1];

class Vector {
public:
  Vector();
  Vector(double, double, double);
  Vector operator*(double);
  Vector operator*=(double);
  Vector operator+(Vector);
  Vector operator+=(Vector);
  Vector operator-(Vector);
  Vector operator-=(Vector);
  double operator*(Vector a);
  
  double norm();
  void normalize();
  double Noise(const LatTyp& lattice);
  Vector dNoise(const LatTyp& lattice);
  double turbulence(const LatTyp& lattice);

public:  
  // These Variables are accessed very often, so I leave them public.
  double x, y, z;
};

#endif
