DirBase=$1
DirA=$2
DirB=$3
DirNew=$4

function usage()
{
	echo
	echo
	echo "Usage: merge.sh"
	echo "merge.sh BaseDir MyDir YourDir NewDir [LogFile]"
	echo
	echo "BaseDir: the directory with your baseline"
	echo "MyDir:   the first copy of the baseline"
	echo "YourDir: the second copy of the baseline"
	echo "NewDir:  the result from merge of MyDir and YourDir"
	echo
	echo "LogFile: file to write log informations"
	echo "         - for stdout"
	echo
	echo "(c) 1999,2000 Tobias Wollgam"
	echo
	echo
}

if test -z "$DirBase" -o -z "$DirA" -o -z "$DirB" -o -z "$DirNew"
then
	usage
	exit
fi

if test ! -d "$DirBase" -o ! -d "$DirA" -o ! -d "$DirB"
then
	usage
	exit
fi

if test ! -d "$DirNew"
then
	mkdir "$DirNew"
fi

if test -z "$5"
then
	LogFile="merge.log"
	rm -f "merge.log"
else
	LogFile=$5
	if test "$LogFile" != "-"
	then
		rm -f "$LogFile"
	fi
fi

function cutname()
{
	c=20

	Name=`echo $1 | cut -d/ -f$c`
	tmp=$Name
	while test $c -gt 1 -a -z "$tmp"
	do
		c=`expr $c - 1`
		tmp=`echo $1 | cut -d/ -f$c`
	done

	echo "$tmp"
}

function cutname2()
{
	echo `echo $1 | tr "/" "\n" | tail -n 1`
}

function cutdir()
{
	echo `echo $1 | cut -f 2- -d '/'`
}

function cutpath()
{
	if test -z `echo $1 | grep /`
	then
		echo ""
	else
		echo `echo $1 | rev | cut -f 2- -d '/' | rev`
	fi
}

function printlog()
{
	if test "$1" = "-"
	then
		echo "$2"
	else
		echo "$2" >> $1
	fi
}

function createfilelist()
{
	diff -r -s -q $1 $2 > /tmp/merge.tmp

	c=1

	tmp2=`cat /tmp/merge.tmp | head -n $c | tail -n 1`

	while(test "$tmp2" != "$tmp")
	do
		tmp=$tmp2
		tmp2=`cat /tmp/merge.tmp | tail -n $c | head -n 1`
		if test -n "`echo $tmp2 | grep identical`"
		then
			file=`echo $tmp2 | cut -f 2 -d ' '`
			list=`echo "$list" " $file"` 
		else
		if test -n "`echo $tmp2 | grep differ`"
		then
			file=`echo $tmp2 | cut -f 2 -d ' '`
			list=`echo "$list" " $file"` 
		else
		if test -n "`echo $tmp2 | grep Only`"
		then
			file=`echo $tmp2 | cut -f 3 -d ' ' | tr -d ':'`
			file="$file/`echo $tmp2 | cut -f 4 -d ' '`"
			list=`echo "$list" " $file"` 
		fi
		fi
		fi
		c=`expr $c + 1` 
	done
	echo $list
}


for i in `createfilelist $DirA $DirB`
do
	file=`cutdir $i`
	dirn=`cutpath $file`
	
	if test ! -d "$DirNew/$dirn"
	then
		mkdir -p "$DirNew/$dirn"
		printlog $LogFile "create $DirNew/$dirn"
	fi
		
	if test -f "$DirBase/$file"
	then
		if test -f "$DirA/$file" -a -f "$DirB/$file"
		then
			if test -n "`diff -q -w -b $DirA/$file $DirB/$file | grep differ`"
			then
				diff3 --merge --text "$DirA/$file" "$DirBase/$file" "$DirB/$file" > $DirNew/$file
				printlog $LogFile "merge $DirA/$file with $DirB/$file"
			else
				cp "$DirA/$file" "$DirNew/$file"
				printlog $LogFile "copy $DirA/$file"
			fi
		else
			if test ! -f "$DirA/$file" -a ! -f "$DirB/$file"
			then
				echo "deleted both $DirBase/$file" >> $LogFile
			else
				if test ! -f "$DirA/$file"
				then
					printlog $LogFile "deleted $DirA/$file"
				else
					printlog $LogFile "deleted $DirB/$file"
				fi
			fi
		fi
	else
		if test -d "$i"
		then
			cp -R "$i" "$DirNew/$dirn"
			printlog $LogFile "added all files in $i"
		else
			printlog $LogFile "added $i"
			cp $i $DirNew/$file
		fi
	fi

done


