/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** patternmodifierdialog_bak.h
*/
#ifndef __PATTERNMODIFIERDIALOG_H__
#define __PATTERNMODIFIERDIALOG_H__


#include <qtabdialog.h>
#include <texture.h>

#include "../../3d/textures/patternmodifier.h"
#include "../misc/vectorwidget.h"
#include "../misc/spinbox.h"
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qradiobutton.h>


class	 PatternModifierDialog: public QDialog
{
Q_OBJECT
protected:
	patternmodifier *modifier;
        QPushButton *ok, *cancel;
	QRadioButton *r1,*r2, *r3;

	int mode;
	VectorWidget *scale, *rotate, *translate;
	VectorWidget *turbulence, *blackhole, *repeat; 
	VectorWidget *repeatwarp, *offsetwarp, *flipwarp;
	VectorWidget *turbulencewarp;
	SpinBox *octaves, *omega, *lambda, *fall_off;
	SpinBox *strength, *blackholeradius;
	QCheckBox *inverse;
	QLabel *inverselabel;
	QComboBox *warpselect;
	void drawIt();

public:
	PatternModifierDialog(QWidget *parent,const char *name,patternmodifier  *p);
	~PatternModifierDialog();
	void	setGeometry(int,int,int,int);

private slots:
	void reject();
	void accept();
	void radio1Pressed();
	void radio2Pressed();
	void radio3Pressed();

signals:
	void	changed();

};


#endif

