/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** interiordialog.h
*/
#ifndef __InteriorDialog_H__
#define __InteriorDialog_H__


#include <qwidget.h>
#include <qgroupbox.h>
#include <qpainter.h>
#include <qcolor.h>
#include <qcombobox.h>
#include <kcolorbtn.h>
#include <qdialog.h>
#include <qlineedit.h>
#include <qpopupmenu.h>

#include "../../3d/textures/interior.h"
#include "../misc/vectorwidget.h"
#include "../widgets/tabwidget.h"
#include "../widgets/percentwidget.h"
//#include "../widgets/sliderwidget.h"
#include <qcolor.h>
#include <qlabel.h>
#include <qframe.h>
#include "transformationswidget.h"
#include "turbulencewidget.h"
#include "densitydialog.h"


class InteriorWidget : public QWidget
{
Q_OBJECT
protected:
	interior  *med;

	QLineEdit *name;
	QLabel	*namelabel,*alabel,*elabel,*slabel,*label4;
	QCheckBox	*active;
	QColor	qc;
	TabWidget	*tab,*tab2;	

	PercentWidget	*scatterecc,*scatterecp;
	SpinBox	*samplemax,*samplemin,*ratio,*confidence,*variance;
	SliderWidget	*intervalls;

	KColorButton	*absorption,*emission,*scatterc;

	TransformationsWidget *tw;
	TurbulenceWidget *tbw;
	QPushButton *transformations,*turbulence,*addElement;

	QWidget *page1,*page2;

	list<DensityWidget *>	densitywidget;
	list<QWidget *>		widgetlist;

public:

	InteriorWidget(QWidget *p, interior *);
	~InteriorWidget();

	void getInterior();

protected:
	void	paintEvent(QPaintEvent*);
protected slots:

	void transformationsPressed();
	void turbulencePressed();
	void addPressed();
};

//---------------------------------------------------------

class InteriorDialog : public QDialog
{
Q_OBJECT
protected:
	QPushButton		*ok,*cancel;
	InteriorWidget		*nw;


public:

	InteriorDialog(QWidget *p, interior *);
	~InteriorDialog();

protected:
	void	paintEvent(QPaintEvent*);

protected slots:
	void okayPressed();
	void cancelPressed();

};


#endif
