/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** interiordialog.cpp
*/
#include "interiordialog.h"
#include "interiordialog.moc"

#include "../widgets/sliderwidget.h"

InteriorWidget::InteriorWidget(QWidget *parent,interior *n) :
	QWidget(parent,"InteriorWidget")
{
color *col;
textureBase *tb;
int x;
QWidget *w;

	med=n;

	label4=NULL;
	tw=NULL;
	tbw=NULL;
	turbulence=NULL;
	transformations=NULL;

	tab=new TabWidget(this,"Density:",1);

	tb=med->getFirstElement();
	while (tb!=NULL) {

		switch(tb->getType()) {
			case DENSITY:
				w=(QWidget *)new DensityWidget(NULL,(Density *)tb);
	     			densitywidget.append( (DensityWidget *)w );
				widgetlist.append (w);
				x=widgetlist.length()-1;
				tab->addWidget(w,x,tb->getName() );

			break;
			case TRANSFORMATIONS:
				transformations=new QPushButton("Transformations...",this);
				connect (transformations,SIGNAL(clicked()),this,SLOT(transformationsPressed()) );
				tw=new TransformationsWidget(NULL,(Transformations*)tb );
				tw->setCaption("Transformations");
			break;
			case TURBULENCEMODIFIER:
				turbulence=new QPushButton("Turbulence...",this);
				connect (turbulence,SIGNAL(clicked()),this,SLOT(turbulencePressed()) );
				tbw=new TurbulenceWidget(NULL,(Turbulence*)tb );
				tbw->setCaption("Turbulence");

			break;
			default:
			break;
		}

		tb=med->getNextElement();
	}

	if (densitywidget.length()==0) label4=new QLabel("no entrys...",this);	

	namelabel=new QLabel("Name:",this);
	name=new QLineEdit(this);
	name->setText(med->getName() );

	tab2=new TabWidget(this,"",0);
	page1=new QWidget();

	col=med->getAbsorption();
	qc.setRgb( (int)(col->red()*255.0), (int)(col->green()*255.0), (int)(col->blue()*255.0) ); //,(int)(col->transparency()*255) );
	absorption=new KColorButton(qc,page1);	
	alabel=new QLabel("Absorption:",page1);

	col=med->getEmission();
	qc.setRgb( (int)(col->red()*255.0), (int)(col->green()*255.0), (int)(col->blue()*255.0) );
	emission=new KColorButton(qc,page1);	
	elabel=new QLabel("Emission:",page1);

       	col=med->getScatter();
	qc.setRgb( (int)(col->red()*255.0), (int)(col->green()*255.0), (int)(col->blue()*255.0) );
	scatterc=new KColorButton(qc,page1);	
	slabel=new QLabel("Scatter:",page1);

	scatterecc=new PercentWidget(page1,"  Excentricity:",med->getScatterECC() );
	scatterecp=new PercentWidget(page1,"  Extinktion  :",med->getScatterEXT() );

	page2=new QWidget();
	
	samplemax=new SpinBox(page2,"Sample Max.:",med->getSampleMax());
	samplemax->DownTopValue(0,1000);

	samplemin=new SpinBox(page2,"Sample Min.:",med->getSampleMin());
	samplemin->DownTopValue(0,1000);

	ratio=new SpinBox(page2,"Ratio:",med->getRatio());
	ratio->DownTopValue(0,1000);

	confidence=new SpinBox(page2,"Confidence:",med->getConfidence());
	confidence->DownTopValue(0,1000);

	variance=new SpinBox(page2,"Variance:",med->getVariance());
	variance->DownTopValue(0,1000);

	intervalls=new SliderWidget(page2,"Intervalls",med->getIntervals(),0,500);

	tab2->addWidget(page1,0,"Colors");
	tab2->addWidget(page2,1,"Parameters");
	tab2->select(1);

	active=new QCheckBox("Active",this);
	addElement=new QPushButton("Add Density",this);
	connect(addElement,SIGNAL(clicked()),this,SLOT(addPressed()) );

	
}

void InteriorWidget::addPressed()
{
QWidget *w;
int x;
textureBase *tb;
	tb=new Density(med);
	med->add(tb);
	w=(QWidget *)new DensityWidget(NULL,(Density *)tb);
	densitywidget.append( (DensityWidget *)w );
	widgetlist.append (w);
	x=widgetlist.length()-1;
	tab->addWidget(w,x,tb->getName() );
	tab->select(x);
	if (label4) {delete label4;label4=NULL;}
}

InteriorWidget::~InteriorWidget()
{
}


void InteriorWidget::getInterior()
{
color *col1=new color(NULL),*col2=new color(NULL);
color *col3=new color(NULL);
int i;

	med->setActive(active->isChecked(),NULL);

	col1->setRed( (double)  (absorption->color().red()/255.0)   );
	col1->setGreen( (double)(absorption->color().green()/255.0) );
	col1->setBlue( (double) (absorption->color().blue()/255.0)  );
	col2->setRed( (double)  (emission->color().red()/255.0)   );
	col2->setGreen( (double)(emission->color().green()/255.0) );
	col2->setBlue( (double) (emission->color().blue()/255.0)  );
	col3->setRed( (double)  (scatterc->color().red()/255.0)   );
	col3->setGreen( (double)(scatterc->color().green()/255.0) );
	col3->setBlue( (double) (scatterc->color().blue()/255.0)  );

	med->setScatter(col3);
	med->setEmission(col2);
	med->setAbsorption(col1);	
	med->setName(name->text() );

	med->setSampleMax(samplemax->getValue() );
	med->setSampleMin(samplemin->getValue() );
	med->setRatio(ratio->getValue() );
	med->setConfidence(confidence->getValue() );	
	med->setVariance(variance->getValue() );
	med->setIntervals(intervalls->getValue() );

	if (tw) tw->getTransformations();
	if (tbw) tbw->getTurbulence();

	for (i=0;i<densitywidget.length();i++) if (densitywidget[i]) densitywidget[i]->getDensity();	

}

void InteriorWidget::transformationsPressed()
{
	tw->resize(180,440);
	tw->setMinimumSize(180,440);
	tw->exec();
}
void InteriorWidget::turbulencePressed()
{
	tbw->resize(270,170);
	tbw->setMinimumSize(270,170);
	tbw->exec();
}


void InteriorWidget::paintEvent(QPaintEvent* qp)
{
	int w=width();
	//int h=height();

	namelabel->setGeometry(100,10,50,25);
	name->setGeometry(155,10,160,25);

        active->setGeometry(320,10,110,25);

	tab2->setGeometry(10,40,w/1.5-15,220);


	if (transformations) transformations->setGeometry(w/1.5+20,100,110,25);
	if (turbulence) turbulence->setGeometry(w/1.5+20,130,110,25);

	alabel->setGeometry(10,10,60,25);
	absorption->setGeometry(75,10,60,25);
	elabel->setGeometry(10,40,60,25);
	emission->setGeometry(75,40,60,25);
	slabel->setGeometry(10,70,60,25);
	scatterc->setGeometry(75,70,60,25);	
	
	scatterecc->setGeometry(10,100,250,25);
	scatterecp->setGeometry(10,130,250,25);

	samplemax->setGeometry(10,10,150,25);
	samplemin->setGeometry(10,40,150,25);

	intervalls->setGeometry(10,70,180,25);

	ratio->setGeometry(10,100,140,25);
	confidence->setGeometry(10,130,140,25);
	variance->setGeometry(10,160,140,25);	

        if (label4) {
		label4->setGeometry(30,290,230,25);
		tab->setGeometry(-400,-300,320,210);
	}
	else tab->setGeometry(10,260,550,300);
	addElement->setGeometry(30,260,110,25);


	QWidget::paintEvent(qp);
}


//----------------------------------------------------------

InteriorDialog::InteriorDialog(QWidget *parent,interior *n) :
	QDialog(parent,"InteriorDialog",true)
{

	ok=new QPushButton("Okay",this);
	cancel=new QPushButton("Cancel",this);

	nw=new InteriorWidget(this,n);

	connect (ok,SIGNAL(pressed()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(pressed()),this,SLOT(cancelPressed()) );

	resize(570,620);
	setMinimumSize(570,620);
	setMaximumSize(570,620);

}


void InteriorDialog::okayPressed()
{  	
	nw->getInterior();   //Widgetwerte in Pointer sichern
	QDialog::done(1);
}

void InteriorDialog::cancelPressed()
{
	QDialog::done(0);
}

InteriorDialog::~InteriorDialog()
{
}

void InteriorDialog::paintEvent(QPaintEvent* qp)
{
	int w=width();
	int h=height();
                       	
	cancel->setGeometry(w-65,h-30,60,25);
	ok->setGeometry(w-65-45,h-30,40,25);
	nw->setGeometry(0,0,w,h-35);

	QDialog::paintEvent(qp);
}

